/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentManageHoldSubCategoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentmanageholdsubcategorygrid',
	store: 'student.managehold.StudentManageHoldSubCatGridStore',
	title: getCommonTranslation("HOLD_SUB_CATEGORY"),
	border: true,
	autoScroll: false,
//	selType: 'checkboxmodel',
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.managehold.StudentManageHoldSubCatGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation("HOLD_CATEGORY_NAME"),
		dataIndex:'holdCategoryName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_SUB_CATEGORY_CODE"),
		dataIndex:'subHoldCatCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_SUB_CATEGORY_NAME"),
		dataIndex: 'subHoldCatName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("APPLY_HOLD_AT"),
		dataIndex: 'applyHoldAt',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			var val;
			if(value=='COURSE_ENROLLMENT'){
				val =getCommonTranslation("COURSE_ENROLLMENT");
			}else if(value=='PROGRAM_BATCH_SECTION_ENROLLMENT'){
             	val =getCommonTranslation("PROGRAM_BATCH_SECTION_ENROLLMENT");
            }else if(value=='RESULT_PUBLISH'){
				val =getCommonTranslation("RESULT_PUBLISH");
			}else if(value=='HALL_TICKET_PUBLISH'){
				val =getCommonTranslation("HALL_TICKET_PUBLISH");
			}else if(value=='PROMOTION'){
				val =getCommonTranslation("PROMOTION");
			}else if(value=='PORTAL_ACCESS'){
				val =getCommonTranslation("PORTAL_ACCESS");
			}else if(value=='NONE'){
				val =getCommonTranslation("NONE");
			}else if(value=='COMMUNICATION_HOLD'){
				val =getCommonTranslation("COMMUNICATION_HOLD");
			}else if(value=='MAKRSHEET_PUBLISH'){
				val =getCommonTranslation("MAKRSHEET_PUBLISH");
			}else if(value=='ASSESSMENT_SCHEME_LEVEL'){
				val =getCommonTranslation("ASSESSMENT_SCHEME_LEVEL");
			}else if(value=='ASSESSMENT_SCHEME_TYPE_LEVEL'){
				val =getCommonTranslation("ASSESSMENT_SCHEME_TYPE_LEVEL");
			}else if(value=='ASSESSMENT_SCHEME_SUBTYPE_LEVEL'){
				val =getCommonTranslation("ASSESSMENT_SCHEME_SUBTYPE_LEVEL");
			}else if(value=='METHOD_LEVEL'){
				val =getCommonTranslation("METHOD_LEVEL");
			}else if(value=='EVENT_LEVEL'){
				val =getCommonTranslation("EVENT_LEVEL");
			}else if(value=='GRADEBOOK_PUBLISH'){
				val =getCommonTranslation("GRADEBOOK_PUBLISH");
			}else if(value=='LOCK_PERSONAL_DETAILS'){
				val =getCommonTranslation("LOCK_PERSONAL_DETAILS");
			}else if(value=='STUDENT_TRANSFER_REQUEST'){
				val =getCommonTranslation("STUDENT_TRANSFER_REQUEST");
			}
			return val;
		}
	},{
		header:  getCommonTranslation("STATUS"),
		dataIndex: 'isActive',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			var val;
			if(value==true){
				val =getCommonTranslation("ACTIVE");
			}else if(value==false){
				val =getCommonTranslation("INACTIVE");
			}
			return val;
		}
	}]
});
