/**
 * @author Deepak Mathur
 * 
 */
Ext.define('Academia.view.personinfo.student.StudentOutstandingReportSendMessages', {
	//extend: 'Ext.window.Window',
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.studentoutstandingreportsendmessages',
	modal: true,
	autoScroll: true,
	frame: true,
	title: getMessagingModuleTranslation('ANNOUNCEMENT'),
	plugins: "formlabelrequired",
	items: [{
		xtype: 'form',
		itemId: 'msgDetailsForm',
		items: [{
			xtype:'hidden',
			name:'adhocMessageID',
			itemId:'adhocMessageID'
		},{
			xtype:'hidden',
			name:'adhocMessageStatus',
			itemId:'adhocMessageStatus'
		},{
			xtype:'hidden',
			name:'messageTemplates',
			itemId:'messageTemplates'
		},{    	    
			xtype:'hidden',
			name:'wsMsgEventRecipientConfigs',
			itemId:'wsMsgEventRecipientConfigs'	        		        		
		},{    	    
			xtype:'hidden',
			name:'wsAdhocRecipients',
			itemId:'wsAdhocRecipients'	        		        		
		},{
			xtype : 'hidden',
			name :'msgRecipientTypeId',
			itemId : 'msgRecipientTypeItemId'
		},{
			xtype : 'hidden',
			name: 'msgCategoryId',
			itemId: 'msgCategoryId'
		},{
			xtype : 'hidden',
			name: 'msgSubCategoryId',
			itemId: 'msgSubCategoryId'
		},{
			xtype : 'hidden',
			name: 'enquiryGridId',
			itemId: 'enquiryGridId'
		},{
			xtype : 'hidden',
			name: 'code',
			itemId: 'code'
		},{
			xtype : 'hidden',
			name: 'id',
			itemId: 'id'
		},{
			xtype : 'hidden',
			name: 'templateConfigName',
			itemId: 'templateConfigName'
		},{
			xtype : 'hidden',
			itemId : 'document_hidden_field',
			name : 'ids'
		}, {
			xtype : 'hidden',
			name : 'module'
		}, {
			xtype : 'hidden',
			name : 'entityId'
		}, {
			xtype : 'hidden',
			name : 'entityType'
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'radiogroup',
				//fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'), //+' <span class="required" style="color:red"> *</span>',
				itemId: 'messageType',
				name:'messageTypeGroup',
				width: 500,
				labelAlign:'top',
				vertical: false,
				allowBlank : false,
				hidden : true,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getMessagingModuleTranslation('Adhoc Message'),
					itemId: 'adhocMessage',
					name: 'messageType',
					inputValue: 2,
					checked: true
				},{
					boxLabel: getMessagingModuleTranslation('Message Template'),
					itemId: 'messageTemplate',
					name: 'messageType',
					inputValue: 1
				}]
			}]},{
				xtype: 'fieldcontainer',
				layout: 'vbox',
				defaults: {
					labelAlign: 'top',
					width: 600,
					height: 65
				},
				items: [{
					   xtype: 'checkboxgroup',
			           fieldLabel: getCommonTranslation('SEND_TO'),
			           itemId: 'recieverType',
					   name: 'recieverType',
			           width: 800,    
			           allowBlank:false,
			           defaults : {
			           getSubmitData: function() {
			   	        var this$ = this,
			   	            data = null,
			   	            val;
			   	        if (!this$.disabled && this$.submitValue && !this$.isFileUpload()) {
			   	            val = this$.getSubmitValue();
			   	            if (val !== null) {
			   	            	//var customValue = "{\"id\":" + val + "}";
			   	            	var customValue = val;
			   	   	            val = Ext.decode(customValue);
			   	                data = {};
			   	   	            //data = [];
			   	                data[this$.getName()] = val;
			   	   	            //data.push(val);
			   	            }
			   	        }
			   	        return data;
			   	    }
			           },
			           items:[{
			        	   boxLabel:getCommonTranslation('STUDENT'),
			        	  inputValue : 1,
			        	  //itemId: 'adhocMessageStudent',
							//name: 'recieverType',
			        	   name:'recieverType'
			           },{
			        	   boxLabel:getCommonTranslation('PARENT'),
			        	   inputValue : 2,
			        	   //itemId: 'adhocMessageParent',
							//name: 'messageType',
			        	   name:'recieverType'
			           },{
			        	   boxLabel:getCommonTranslation('FEE_PAYER'),
			        	   inputValue : 3,
			        	   //itemId: 'adhocMessageFeePayer',
							//name: 'messageType',
			        	   name:'recieverType'
			           },{
			        	   boxLabel:getCommonTranslation('SEND_MESSAGE_INCLUDE_MYSELF_MSG'),
			        	   inputValue : 4,
			        	   itemId:'recieverTypeIncludeMySelf',
			        	   name:'recieverType',
			        	   checked:true
			           }]
				
				}]
			},			{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [ {
					xtype: 'textfield',
					fieldLabel: getMessagingModuleTranslation('MESSAGE_ID'),
					name: 'messageId',
					itemId: 'messageId',
					emptyText: getCommonTranslation('ID_AUTOGENERATE'),
					readOnly:true,
					hidden: true,
				},{
					xtype: 'textfield',
					fieldLabel: getMessagingModuleTranslation('MESSAGE_NAME'),
					name: 'displayCode',
					itemId: 'messageName',
					allowBlank: false,
					hidden: true,
				}]},{
					xtype: 'fieldcontainer',
					width: '100%',
					layout: {
						type: 'vbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel:  getMessagingModuleTranslation('SELECT_TEMPLATE'),                
						name: 'msgTemplateConfigId',
						emptyText :  getCommonTranslation('ENTER_THREE_CHAR'),      
						itemId : 'selectTemplate',   
						displayField : 'templateConfigName',
						valueField:'id',
						store:'messaging.MessagingTemplatesStore',
						allowBlank: false ,
						queryParam :'searchString', 
						hidden: true
					}]
				},{
					xtype: 'fieldcontainer',
					width: '100%',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel:  getMessagingModuleTranslation('SELECT_MESSAGE_TYPE'),     // select Email or sms           
						name: 'msgTempletId',
						// emptyText :  getCommonTranslation('ENTER_THREE_CHAR'),      
						itemId : 'msgTempletId',   
						displayField : 'value',
						valueField:'id',
						store:'committee.committee.MessageTypeNotificationStore',
						allowBlank: false 
					},{
						xtype: 'textfield',
						fieldLabel: getMessagingModuleTranslation('SUBJECT'), 	// for subject
						name: 'subjectDisplayCode',
						itemId: 'subject',
						allowBlank: false
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'vbox',
					defaults: {
						labelAlign: 'top',
						width: 440
					},
					items: [{
						xtype: 'textarea',
						fieldLabel: getMessagingModuleTranslation('Description'), 	// for subject
						name: 'smsDiscription',
						itemId: 'smsDiscription',
						maxLength: 900,
						hidden:true,
						height: 200
						// allowBlank: false
					},{
						xtype:'displayfield',
						name:'smsDiscriptionNotice',
						itemId:'smsDiscriptionNotice',
					//	fieldLabel: '<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+'</span>',
						value: '<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE_CONSTANT')+'</span>',
						hidden:true,
						style:'padding-bottom:20px;'
					},{
						xtype: 'textarea',
						fieldLabel: getMessagingModuleTranslation('Description'), 
						name: 'pushNotificationDiscription',
						itemId: 'pushNotificationDiscription',
						maxLength: 1000,
						hidden:true,
						width: 462,
						height: 200
						// allowBlank: false
					},{
						xtype:'displayfield',
						name:'pushNotificationDiscriptionNotice',
						itemId:'pushNotificationDiscriptionNotice',
						value: '<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE_CONSTANT')+'</span>',
						hidden:true,
						style:'padding-bottom:20px;'
					},{
			                xtype: 'ckeditor',
					        itemId: 'discriptionId',
					        name:'discriptionId',
					        height: 400,
					        width:700,
					        maxLength: 9999999
						}]
					},{
						xtype: 'fieldcontainer',
						layout: 'vbox',
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [ {
							xtype : 'filefield',
							itemId : 'staticUploadFileField',
							hidden: true,
							width:226,
							fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
							ui : 'CustomBtnSubmit',
							buttonText : getPersonModuleTranslation('UPLOAD'),
							name : 'file'
						}]},{
							xtype: 'fieldcontainer',
							layout: 'vbox',
							itemId : 'studentDocumentMessageAttachmentGrid',
							hidden: true,
							defaults: {
								labelAlign: 'top',
								width: 226
							},style:{
								marginLeft: '-18px'
							},							
							items: [{
								xtype : 'studentoutstandingstaticdocumentattachmentgrid',
								itemId : 'studentOutstandingStaticDocumentAttachmentGridMessage',
								width: 300
							}]
						},{
							xtype: 'fieldcontainer',
							layout: 'hbox',
							defaults: {
								labelAlign: 'top',
								width: 226
							},
							items: [{
								xtype: 'radiogroup',
								fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'), //+' <span class="required" style="color:red"> *</span>',
								itemId: 'sendingPriority',
								name:'sendingPriority',
								width: 500,
								labelAlign:'top',
								vertical: false,
								allowBlank : false,
								layout: {
									type: 'hbox'
								},
								items: [{
									boxLabel: getMessagingModuleTranslation('IMMEDIATE'),
									itemId: 'immediate',
									name: 'sendingPriority',
									inputValue: 'IMMEDIATE',
									checked: true
								}, {
									boxLabel: getMessagingModuleTranslation('SCHEDULE'),
									itemId: 'schedule',
									name: 'sendingPriority',
									inputValue: 'SCHEDULE',
								}]
							}]
						},{
							xtype: 'fieldcontainer',
							width: '100%',
							style:{
								marginLeft: '3px',
								marginTop : '-7px'
							},
							layout: {
								type: 'hbox'
							},
							defaults: {
								labelAlign: 'top',
								width: 226
							},
							items: [{
								xtype: 'datefield',
								fieldLabel: getMessagingModuleTranslation('SCHEDULE_DATE'),
								name: 'msgDueDate',
								hidden: true,
								editable: false,
								itemId: 'scheduleDate',
//								format: CONSTANTS.DATE_FORMAT,
								minValue: new Date(),
								//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
								listeners: {
									render: function(field) {
										return dateFormatRender(field);
									},
									change : function(field) {
										var form = field.up('form');
										var scheduleTime = form.down("#scheduleTime");
										var msgDueDateVal = field.getValue();
										if(Ext.Date.format(msgDueDateVal, CONSTANTS.DATE_FORMAT) 
												== Ext.Date.format(new Date(), CONSTANTS.DATE_FORMAT))
											scheduleTime.setMinValue(new Date());
										else {
											scheduleTime.setMinValue(msgDueDateVal);
										}
									}
								}
							},{
								xtype: 'timefield',
								name: 'msgDueDateTime',
								itemId: 'scheduleTime',
								hidden: true,
								fieldLabel: getMessagingModuleTranslation('SCHEDULE_TIME'),
								format: CONSTANTS.DISPLAY_TIME_FORMAT,                
								increment: 30,
//								minValue:Ext.Date.format(new Date(),CONSTANTS.DISPLAY_TIME_FORMAT),
								editable: false
							}]        
						},{
							xtype: 'fieldcontainer',
							width: '100%',
							style :{
								marginLeft :'1px',
								marginTop :'19px'
							},
							items: [{
								xtype: 'button',
								text: getServiceRequestTranslation('SUBMIT'),
								itemId: 'adhocMsgSubmitBtn',
								buttonAlign: 'right',
								ui: 'CustomBtnSubmit',
								formBind : true,
								scale: CONSTANTS.BUTTONSIZE              
							}/*, {
								xtype: 'button',
								text: getServiceRequestTranslation('CANCEL'),
								ui: 'CustomBtnCancel',
								itemId: 'followUpDetailsCancelButtonId',
								scale: CONSTANTS.BUTTONSIZE,
								handler :function(button) {
									button.up('window').close();
								}
							}*/]
						}]
	}],
	/**
	 * This method is used to send message
	 */
	sendMessage : function(button,grid,wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId,msgMySelfRecipientTypeId){
		baseController = Academia.app.getController('Academia.controller.base.BaseController');
		var formData = button.up('form').getValues();
		var recipientIds = null;
		var typeId = null;
		var recipientId = null; 
		if(grid.itemId == 'studentoutstandingreportgrid'){
			recipientIds = this.getStudentReceipientIds(grid);
			typeId = 2;
			recipientId = 2;
		}
		
		var basicSetUpForm=button.up('form');

		var staticDocumentGrid = basicSetUpForm.down('#studentOutstandingStaticDocumentAttachmentGridMessage');//this.getStaticDocumentAttachmentGrid();
		var staticDocumentStore = staticDocumentGrid.getStore();
		var staticDocuments = new Array();
		staticDocumentStore.each(function(values){

			var staticDocumentObject = new Object();

			staticDocumentObject.id = values.get('id');
			staticDocumentObject.templateConfigDocId = values.get('templateConfigDocId');
			staticDocumentObject.name = values.get('name');
			var date = values.get('submissionDate');
			if(isNullOrEmpty(date)){
				date = Ext.Date.format(new Date(), 'd-m-Y');
			}

			staticDocumentObject.submissionDate = date;
			staticDocumentObject.path = values.get('path');
			staticDocumentObject.createdBy = {
					id : values.get('createdBy').id,
					value : values.get('createdBy').value,
					code : values.get('createdBy').code
			},
			staticDocumentObject.status = values.get('status');
			staticDocumentObject.documentType = values.get('documentType');
			staticDocuments.push(staticDocumentObject);
		});


		if(formData.messageType=="2")
		{

			var json = new Object();
//			json.id = formData.id;
//			json.code = formData.code;
//			json.templateConfigName = formData.templateConfigName;
			json.msgSubCategoryId = formData.msgSubCategoryId;
			json.templateDataProviderId = null;
			json.whetherStaticMsg = false;
			//json.recipientTypeId = 43;
			json.recipientTypeId = typeId;
			json.msgMessageTypeId = 4;
			json.approvalRequired = false;
			json.approverId = null;
			json.academyLocationId = 3;
			json.authorId = 1;
			json.authorName = "System Admin System Admin";
			json.availableForAdhocMsg = true;
			json.status = "APPROVED";
			json.staticDocuments = staticDocuments;
			var jsonData=[];
			if(formData.msgTempletId =="EMAIL_SYSTEM_NOTIFICATION")
			{
				var obj1 = new Object();

				//var objArr = new Array();
				var arr1 = new Object();
				arr1.id = 1;
				arr1.code = 'Email';
				arr1.whetherMsgSubjAvail = true;
				arr1.whetherAttachmentSupported = true;

				//objArr.push(arr1);

				obj1.subjectLine = formData.subjectDisplayCode;
				obj1.msgContent = formData.discriptionId;
				obj1.msgDeliveryMode = arr1;

				var tempArr = new Array();
				var tempObj = new Object();

				tempArr.push(obj1);
				json.messageTemplates = tempArr
				//json.push(tempObj);
			}else if(formData.msgTempletId =="PUSH_NOTIFICATION")
			{
				var obj1 = new Object();

				//var objArr = new Array();
				var arr1 = new Object();
				arr1.id = 6;
				arr1.code = 'PUSH_NOTIFICATION';
				arr1.whetherMsgSubjAvail = true;
				arr1.whetherAttachmentSupported = false;

				//objArr.push(arr1);

				obj1.subjectLine = formData.subjectDisplayCode;
				obj1.msgContent = formData.discriptionId;
				obj1.msgDeliveryMode = arr1;

				var tempArr = new Array();
				var tempObj = new Object();

				tempArr.push(obj1);
				json.messageTemplates = tempArr
				//json.push(tempObj);
			}else if(formData.msgTempletId =="EMAIL_ONLY")
			{
				var obj1 = new Object();

				var arr1 = new Object();
				arr1.id = 1;
				arr1.code = 'EMAIL_ONLY';
				arr1.whetherMsgSubjAvail = true;
				arr1.whetherAttachmentSupported = true;


				obj1.subjectLine = formData.subjectDisplayCode;
				obj1.msgContent = formData.discriptionId;
				obj1.msgDeliveryMode = arr1;

				var tempArr = new Array();
				var tempObj = new Object();

				tempArr.push(obj1);
				json.messageTemplates = tempArr
			}else if(formData.msgTempletId =="SYSTEM_NOTIFICATION")
			{
				var obj1 = new Object();

				var arr1 = new Object();
				arr1.id = 4;
				arr1.code = 'SYSTEM_NOTIFICATION';
				arr1.whetherMsgSubjAvail = true;
				arr1.whetherAttachmentSupported = true;


				obj1.subjectLine = formData.subjectDisplayCode;
				obj1.msgContent = formData.discriptionId;
				obj1.msgDeliveryMode = arr1;

				var tempArr = new Array();
				var tempObj = new Object();

				tempArr.push(obj1);
				json.messageTemplates = tempArr
			}else if(formData.msgTempletId =="PUSH_NOTIFICATION_ONLY")
			{
				var obj1 = new Object();
				var arr1 = new Object();
				arr1.id = 6;
				arr1.code = 'PUSH_NOTIFICATION_ONLY';
				arr1.whetherMsgSubjAvail = true;
				arr1.whetherAttachmentSupported = false;

				//objArr.push(arr1);

				obj1.subjectLine = formData.subjectDisplayCode;
				//obj1.msgContent = formData.pushNotificationDiscription;
				obj1.msgContent = formData.discriptionId;
				obj1.msgDeliveryMode = arr1;

				var tempArr = new Array();
				var tempObj = new Object();

				tempArr.push(obj1);
				json.messageTemplates = tempArr
				//json.push(tempObj);
			}else
			{
				var obj1 = new Object();

				var arr1 = new Object();
				arr1.id = 2;
				arr1.code = 'SMS';
				arr1.whetherMsgSubjAvail = false;
				arr1.whetherAttachmentSupported = false;

				//objArr.push(arr1);

				obj1.subjectLine = formData.subjectDisplayCode;
				obj1.msgContent = formData.smsDiscription;
				obj1.msgDeliveryMode = arr1;

				var tempArr = new Array();
				var tempObj = new Object();

				tempArr.push(obj1);
				json.messageTemplates = tempArr

				//json.push(jsonData);

			}
			jsonDataEncode = Ext.encode(json);
			Ext.Ajax.request({
				type: 'rest',
				//url: SERVERURL.ADHOC_MESSAGE_UPDATE_COMMITTEE,
				url: SERVERURL.ADHOC_MESSAGE_UPDATE_TEMPLATE_CONFIG,
				jsonData: jsonDataEncode,
				method: 'POST',
				success: function(form, action) {
					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					var templateConfigId = Ext.decode(form.responseText);
					submitUrl = SERVERURL.ADOC_MESSAGEING_CREATE; 
					var submitUrl;
					/*var wsMsgEventRecipientConfigsUpdated = [{ 
								                            	 msgRecipientTypeId: recipientId,
								                            	 msgTemplateConfigId:templateConfigId,	//formData.id, 
								                            	 selectiveRecipientIds:recipientIds 
								                            }];*/
					var json = {
							id: null, 
							status: null, 
							//msgTemplateConfigId: formData.id, 
							sendingPriority: formData.sendingPriority, 
							msgCategoryId:formData.msgCategoryId, 
							msgSubCategoryId: formData.msgSubCategoryId, 
							messageId: formData.messageId, 
							displayCode: formData.subjectDisplayCode, 
							wsMsgEventRecipientConfigs: [ 
							                             /*{ 
							                            	 msgRecipientTypeId: recipientId,
							                            	 msgTemplateConfigId:templateConfigId,	//formData.id, 
							                            	 selectiveRecipientIds:recipientIds 
							                             },
							                             { 
							                            	 msgRecipientTypeId: 42,
							                            	 msgTemplateConfigId:templateConfigId, 
							                            	 selectiveRecipientIds:[4,7] 
							                             }*/
							                             ], 
							                             wsAdhocRecipients: null, 
							                             approverId: null, 
							                             approvalRequired: false, 
							                             reviewStatusCode: "APPROVED"
							                             //recieverType: formData.recieverType
					};
					
					if(isStudentChecked){
						json.wsMsgEventRecipientConfigs.push({ 
                           	 msgRecipientTypeId: recipientId,
                        	 msgTemplateConfigId:templateConfigId,	//formData.id, 
                        	 selectiveRecipientIds:recipientIds 
                         });
					}
					if(isMySelfChecked[3]){
						if(msgMySelfRecipientTypeId==null){
							msgMySelfRecipientTypeId=166;
						}
						json.wsMsgEventRecipientConfigs.push({ 
							msgRecipientTypeId: msgMySelfRecipientTypeId,
							msgTemplateConfigId:templateConfigId,	//formData.id, 
							selectiveRecipientIds:[currentlyLoggedInUserId]
						});
					}
					
					if(wsMsgEventRecipientConfigsUpdated.length > 0){
						wsMsgEventRecipientConfigsUpdated.forEach(function(current_value, index, initial_array) {
							//current_value.msgRecipientTypeId = recipientId;
							current_value.msgTemplateConfigId = templateConfigId;
							json.wsMsgEventRecipientConfigs.push(current_value);
						});
					}
					
					console.log(json.wsMsgEventRecipientConfigs);

					if(formData.sendingPriority==="SCHEDULE"){
						if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
							var dateString="";
							dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
							json.msgDueDate=dateString;
						}else{
							json.msgDueDate= null;
						}
					}else if(formData.sendingPriority==="IMMEDIATE"){
						/*var now = new Date();
						var dateString = Ext.Date.format(now,'Y-m-d h:i A');*/
						json.msgDueDate=null;
					}else{
						json.msgDueDate= null;
					}
					//var x = xyz.id;
					//delete myObj.test.key1;
					var academyLocation=baseController.getCurrentAcademyLocation();
					if(!isNullOrEmpty(academyLocation)){
						json.academyLocationId=academyLocation;
					}

					var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
					if(!isEmpty(currentlyLoggedInUser)){
						json.authorId=currentlyLoggedInUser.id;
						json.authorName=currentlyLoggedInUser.value;
					}
					jsonDataEncode = Ext.encode(json);
					var $this = this;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : jsonDataEncode,
						method : 'POST',
						success : function(frm, action) {
							Ext.getBody().unmask();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll(true);
							 var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
							  var getcontroller=Academia.app.getController('menu.CoreERPNavigationController');
					       	   var getTab=getcontroller.getTab(tabName);
					       	   if(getTab!=null){
					       		   contentPanel.remove(getTab, true);
					       	   }
							showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
						}
					});

				}

			});


		}else
		{	
			baseController = Academia.app.getController('Academia.controller.base.BaseController');
			var recipientIds = null;
			msgRecipientType = null;
			if(grid.itemId == 'studentoutstandingreportgrid'){
				recipientIds = this.getStudentReceipientIds(grid);
				msgRecipientType = 2;
			}
			/**
			 * The below changes were done for Applicant Adhoc message
			 *//*
				var typeId;
				if(formData.msgRecipientTypeId == 10){
					typeId = 32;
				} 		
				else {
					if(formData.msgRecipientTypeId == 8){
						typeId = 42;
					}else{
						typeId = formData.msgRecipientTypeId;
					}			
				}*/

			var json = {
					id: null, 
					status: null, 
					msgTemplateConfigId: null, 
					sendingPriority: formData.sendingPriority, 
					msgCategoryId:formData.msgCategoryId, 
					msgSubCategoryId: formData.msgSubCategoryId, 
					messageId: formData.messageId, 
					displayCode: formData.displayCode, 
					wsMsgEventRecipientConfigs: [ 
					                             /*{ 
					                            	 msgRecipientTypeId: msgRecipientType,
					                            	 msgTemplateConfigId:formData.msgTemplateConfigId, 
					                            	 selectiveRecipientIds:recipientIds 
					                             },
					                             { 
					                            	 msgRecipientTypeId: 42,
					                            	 msgTemplateConfigId:formData.msgTemplateConfigId, 
					                            	 selectiveRecipientIds:[4,7] 
					                             }*/
					                             ], 
					                             wsAdhocRecipients: null, 
					                             approverId: null, 
					                             approvalRequired: false, 
					                             reviewStatusCode: "APPROVED",
					                             //recieverType: formData.recieverType

			};
			
			if(isStudentChecked){ 
				json.wsMsgEventRecipientConfigs.push({ 
                   	 msgRecipientTypeId: msgRecipientType,
                	 msgTemplateConfigId:formData.msgTemplateConfigId, 
                	 selectiveRecipientIds:recipientIds 
                 });
			}
			if(isMySelfChecked[3]){
				if(msgMySelfRecipientTypeId==null){
					msgMySelfRecipientTypeId=166;
				}
				json.wsMsgEventRecipientConfigs.push({ 
					msgRecipientTypeId: msgMySelfRecipientTypeId,
					msgTemplateConfigId:formData.msgTemplateConfigId,	//formData.id, 
					selectiveRecipientIds:[currentlyLoggedInUserId]
				});
			}
			
			if(wsMsgEventRecipientConfigsUpdated.length > 0){
				wsMsgEventRecipientConfigsUpdated.forEach(function(current_value, index, initial_array) {
					//current_value.msgRecipientTypeId = msgRecipientType;
					current_value.msgTemplateConfigId = formData.msgTemplateConfigId;
					json.wsMsgEventRecipientConfigs.push(current_value);
				});
			}
			
			if(formData.sendingPriority==="SCHEDULE"){
				if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
					var dateString="";
					dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
					json.msgDueDate=dateString;
				}else{
					json.msgDueDate= null;
				}
			}else if(formData.sendingPriority==="IMMEDIATE"){
				//var now = new Date();
				//var dateString = Ext.Date.format(now,'Y-m-d h:i A');
				json.msgDueDate=null;
			}else{
				json.msgDueDate= null;
			}

			var academyLocation=baseController.getCurrentAcademyLocation();
			if(!isNullOrEmpty(academyLocation)){
				json.academyLocationId=academyLocation;
			}

			var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
			if(!isEmpty(currentlyLoggedInUser)){
				json.authorId=currentlyLoggedInUser.id;
				json.authorName=currentlyLoggedInUser.value;
			}
			jsonDataEncode = Ext.encode(json);
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.ADOC_MESSAGEING_CREATE,
				jsonData: jsonDataEncode,
				method: 'POST',
				success: function(form, action) {
					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
					grid.getStore().reload();
					grid.getSelectionModel().deselectAll(true);
					 var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
					  var getcontroller=Academia.app.getController('menu.CoreERPNavigationController');
			       	   var getTab=getcontroller.getTab(tabName);
			       	   if(getTab!=null){
			       		   contentPanel.remove(getTab, true);
			       	   }
					//button.up('window').close();
				}

			});
		}	
	},
	 updateCounter: function(textarea)
	    {
		 textarea.counterEl.update('' + 
	            (textarea.maxLength - textarea.getValue().length));
	    },
	/**
	 * This method is used to get Ids 
	 */
	getReceipientIds : function(grid){
		
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			var ids=[];
			Ext.Array.each(records,function(value){
				for(var i in value.data.committeeParticipants) {
					ids.push(value.data.committeeParticipants[i].id);
				}
				//ids.push(value.data.id);
			});
		}
		return ids;
	},
	/**
	 * This method is used to get Ids for Student
	 */
	getStudentReceipientIds : function(grid){
		
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			var ids=[];
			if(grid.itemId == 'studentoutstandingreportgrid'){
				for(var i in records) {
					ids.push(records[i].data.admissionId);
				}
			}			
		}
		return ids;
	}
});