/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.personinfo.student.StudentPortalFinanceHoldsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentportalfinanceholdsgrid',
	store: 'student.managehold.StudentFinanceHoldGridStore',
	title: getCommonTranslation("FINANCE_HOLDS"),
	border: true,
	autoScroll: false,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation("FINANCE_HOLD_ID"),
		dataIndex:'financeHoldCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("FINANCE_HOLD_NAME"),
		dataIndex: 'financeHoldName',
		flex:.1,
		sortable:true,
	},{
		header:  getCommonTranslation("FINANCE_HOLD_TYPE"),
		dataIndex: 'financeHoldType',
		flex:.1,
		sortable:true,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
		
	},{
		header:  getCommonTranslation("PENDING_FEE"),
		dataIndex: 'pendingFee',
		flex:.1,
		sortable:true,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return value +'%';
		}
	},{
		header:  getCommonTranslation("DUE_FEE_AMOUNT"),
		dataIndex: 'pendingAmount',
		flex:.1,
		sortable:true,
		
	}],

	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.managehold.StudentFinanceHoldGridStore');
	}
});