/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.placement.PlacementDetailReport.PlacementDetailReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementdetailreportgrid',
	store: 'placement.PlacementDetailReport.PlacementDetailReportGridStore',
	title: getMegaMenuTranslation('PLACEMENT_DETAIL_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'placementdetailreporttabstructure':1
		}
	},*/
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.PlacementDetailReport.PlacementDetailReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	columns: [{
		header:  getPlacementTranslation('SUDUENT_NUMBER'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('SURNAME'),
		dataIndex: 'lastName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.1
	},{
		header:  getCommonTranslation('ID_NUMBER'),
		dataIndex: 'nationalId',
		flex:.1
	},{
		header:  getCommonTranslation('GENDER'),
		dataIndex: 'gender',
		flex:.1
	},{
		header:  getPlacementTranslation('ETHINIC_GROUP_NAME'),
		dataIndex: 'casteCategory',
		flex:.1
	},{
		header:  getPlacementTranslation('ACADEMIC_YEAR'),
		dataIndex: 'intakeYear',
		flex:.1
	},{
		header:  getPlacementTranslation('ACADEMIC_BLOCK_CODE'),
		dataIndex: 'academicTerm',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('EMPLOYER_CODE'),
		dataIndex: 'employerCode',
		flex:.1,
		sortable:true
    },{
		header:  getPlacementTranslation('EMPLOYER_NAME'),
		dataIndex: 'employerName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('QUALIFICATION_NAME'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('INDUSTRY_CATEGORY_DESCRIPTION'),
		dataIndex: 'industryCategory',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('COOP_STATUS'),
		dataIndex: 'offerStatus',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				if(value == "PENDING"){
					return getCommonTranslation('PENDING');
				}
				else if(value == "OFFERED"){
					return getCommonTranslation('OFFERED');
				}				
			}else{
				return null;
			}
		}
	},{
		header:  getPlacementTranslation('REMARKS'),
		dataIndex: 'remarks',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACED_DATE'),
		dataIndex: 'placedDate',
		flex:.1,
		sortable:true,
		renderer: function(date) {
			return dateRender(date);
		}
	}]
});

