/**
 * @author Vishal Joshi
 * @author Amit Gupta
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusFilter', {
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.placementcampusfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
            xtype: 'customcombobox',
            name: 'intakeYearPlcDriveId',
            itemId: 'intakeYearPlcDriveId',
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            store: Ext.create('Academia.store.common.IntakeYearStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false, 
		},{
			xtype: 'customcombobox',
			name: 'placementcampus',
			itemId:'placementcampusItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'placementtype',
			fieldLabel: getPlacementTranslation('PLACEMENT_TYPE'),
			itemId:'placementtypeItemId',
			store:'placement.PlacementTypeStore',
			displayField:'value',
			valueField:'id',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [
		        {
		        	xtype: 'fieldcontainer',
		        	width: 'auto',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 226,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		xtype: 'nestedJsonCombo',
		        		name:'campusCoordinator',
		        		itemId:'campusCoordinator',
		        		store: 'placement.placementcampus.placementCampusCoordinatorStore',
		        		fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_COORDINATOR'),
		        		valueField: 'id',
		        		displayField: 'valueCode',
		        		queryParam:'name',
		    			minChars:3,
		    			typeAhead:false,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width:226,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'academyLocation',
		        		itemId:'academyLocation',
		        		store:'placement.placementcampus.PlacementCampusRecOrgALStore',
		        		allowBlank:true,
		        		fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		queryParam:'academyLocationName',
		    			minChars:3,
		    			typeAhead:false,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width:226,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	},{
		        		
		        		xtype: 'nestedJsonCombo',
		        		name: 'organizingAcademyLocation',
		        		itemId:'organizingAcademyLocation',
		        		store:'placement.placementcampus.placementCampusOrgAlStore',
		        		allowBlank:true,
		        		fieldLabel: getPlacementTranslation('ACADEMY_LOCATION'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		queryParam:'name',
		    			minChars:3,
		    			typeAhead:false,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width:226,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	}]	
		        },{
		        	xtype: 'fieldcontainer',
		        	width: 'auto',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 226,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		xtype: 'nestedJsonCombo',
		        		name: 'programName',
		        		itemId:'programId',
		        		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		        		store:'common.ProgramByAcademyLocationStore',
		        		allowBlank:true,
		        		valueField: 'id',
		        		displayField: 'valueCode',
		        		disabled:true,
		        		enforceMaxLength : true,
		        		maxLength:255,
		        		regex: /[a-zA-Z0-9]+/,
		        		typeAhead: true,
		                forceSelection: true,
		                triggerAction: 'all',
		                queryParam:'programName',
		                minChars:3,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 			listConfig: {
			 				listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			 				loadingText: getCommonTranslation('SEARCHING'),
			 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			 				getInnerTpl: function() {
			 					return '<div class="search-item">' +
			 					'{value}' +
			 					'</div>';
			 				}
			 			}
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'batchName',
		        		itemId:'batchId',
		        		fieldLabel: getCommonTranslation('BATCH'),
		        		store:'common.BatchesByProgramId',
		        		valueField: 'id',
		        		displayField: 'value',
		        		allowBlank: true,
		        		typeAhead:true,
		        		disabled:true,
		        		forceSelection:true
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'periodName',
		        		itemId:'periodId',
		        		fieldLabel: getCommonTranslation('PERIOD'),
		        		store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		        		valueField: 'id',
		        		displayField: 'value',
		        		allowBlank: true,
		        		typeAhead:true,
		        		disabled:true,
		        		forceSelection:true
		        	}]
		        },{
		        	xtype: 'fieldcontainer',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 226,
		        		labelAlign: 'top'
		        	},
		        	items : [{
		        		xtype: 'datefield',
		        		name: 'startDate',
		        		itemId:'startDate',
		        		allowBlank:true,
		        		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
		        		listeners: {
		        			render: function(field) {
		        				return dateFormatRender(field);
		        			}
		        		},
		        		vtype: 'daterange',
		    			endDateField: 'endDate',
		    			editable:false,
		        		fieldLabel:getPlacementTranslation('START_DATE')
		        	},{
		        		xtype: 'datefield',
		        		name: 'endDate',
		        		itemId:'endDate',
		        		allowBlank:true,
		        		vtype: 'daterange',
		    			startDateField: 'startDate',
		    			editable:false,
		    			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
		        		listeners: {
		        			render: function(field) {
		        				return dateFormatRender(field);
		        			}
		        		},
		        		fieldLabel:getPlacementTranslation('END_DATE')
		        	}] 

		        }]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
