/**
 * @author Amit.G
 */

Ext.define('Academia.view.placement.placementjob.PlacementJobLocationDetailForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.placementjoblocationdetailform',
	title:getPlacementTranslation('PLACEMENT_JOB_LOCATION_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'joblocationdetailform',
		itemId:'placementjoblocationdetailform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'hidden',
			name: 'placementJobId'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'placementJobLocationMasterId',
				itemId:'academyLocation',
				store:'placement.placementjob.PlacementJobLocationListStore',
				allowBlank:false,
				fieldLabel: getPlacementTranslation('PLACEMENT_JOB_LOCATION_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'placementJobLocation',
				typeAhead:true,
				disabled:false,
				editable:false,
//				forceSelection:true
			
			},{
				xtype: 'customcombobox',
        		name:'coordinatorId',
        		itemId:'campusCoordinator',
        		store: 'placement.placementcampus.placementCampusCoordinatorStore',
        		fieldLabel : getPlacementTranslation('PLACEMENT_LOCATION_COORDINATOR'),
        		valueField: 'id',
        		displayField: 'valueCode',
        		queryParam:'name',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
			}]
		},{
			xtype:'fieldcontainer',
			itemId:'jobDetailContainerId',
//			itemId:'stopPanelId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				//itemId:'stopContainer',
				itemId:'jobDetailContainer',
				layout : 'hbox',
				defaults: {
					labelAlign: 'top'
				},
				items : [{
					xtype: 'customcombobox',
	                name: 'placementDesignationId',
	                itemId: 'designation',
	                fieldLabel: getPlacementTranslation('PLACEMENT_JOB_DESIGNATION'),
	                editable: true,
	                valueField: 'id',
	                displayField: 'value',
	                allowBlank:false,
	                store: 'placement.placementjob.PlacementJobLocationDesignationStore',
	                editable:false,
	              
				},{
					xtype: 'numberfield',
					itemId: 'noOfPosition',
					 fieldLabel: getPlacementTranslation('PLACEMENT_JOB_NO_OF_POSITIONS'),
					labelAlign: 'top',
					width: 139,
					name: 'noOfPosition',
					minValue: 0,
                    allowDecimals:false,
                    allowBlank: false,
		        	hideTrigger:true,
		        	mouseWheelEnabled:false
				},{
					xtype: 'customcombobox',
	                itemId:'salaryPackage',
	                disabled:false,
	                editable: false,
	                displayField: 'value',
	                valueField: 'id',
	                allowBlank:true,
	                store: 'placement.placementjob.PlacementJobLocationSalaryRangeStore',
	                fieldLabel: getPlacementTranslation('PLACEMENT_JOB_LOCATION_SALARY_PACKAGE'),
	                name: 'salaryPackageId'
	            
				},{
					xtype: 'button',
					itemId: 'addFilterBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				  }]
				}]
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
	    		text: getCommonTranslation('RESET'),
	    		//itemId: 'programFormCancelButtonId',
	    		itemId: 'resetBtn',
	    		ui: 'CustomBtnCancel',
	    		scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});