/**
 * @author Deepika Parmar
 */
var gridStore = Ext.create('Academia.store.placement.placementjobapplication.ManageApplicationStatusGridStore');
Ext.define('Academia.view.placement.placementjobapplication.ManageApplicationStatusGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageapplicationstatusgrid',
	store: gridStore,
	title:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_LIST_OF_STUDENT'),
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : gridStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [ {
			xtype : 'button',
			text : getPlacementTranslation('SAVE') ,
			itemId : 'saveApplication',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			disabled:true
			
		}]
	}],
	columns: [{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('MANAGE_APPLICATION_STATUS'),
		dataIndex: 'selectionProcessName',
		flex:.1,
		editor:{
			xtype:'textfield',
			itemId:'manageApplicationStatusField',
			maxLength:50
		},
		renderer:function(value,metaData ,record ,rowIndex ,colIndex ,store,view  ){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				metaData.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1
	}
});

