/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementjobapplicationgrid',
	store: 'placement.placementjobapplication.PlacementJobApplicationGridStore',
	title:  getCommonTranslation('JOB_APPLICATION_LIST'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementjobapplication.PlacementJobApplicationGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text: getPlacementTranslation('Add_APPLICATION'),
		itemId: 'addApplication'
	}, {
		xtype: 'button',
		text: getPlacementTranslation('SEND_OFFER_LETTER'),
		itemId: 'sendOfferLetter',
    	hidden:true
	}, {
		xtype: 'button',
		text: getPlacementTranslation('UPDATE_OFFER_STATUS'),
		itemId: 'updateOfferStatus'
	}, {
		xtype: 'button',
		text: getPlacementTranslation('UPDATE_JOINING_STATUS'),
		itemId: 'updateJoiningStatus'
	},{
		xtype: 'button',
		text: getPlacementTranslation('UPLOAD_RESUME'),
		itemId: 'uploadResume',
		buttonAlign: 'left'
	},{
		xtype: 'button',
		text: getPlacementTranslation('PLACEMENT_APP_SEND_MSG'),
		itemId: 'sendMessage',
		buttonAlign: 'left'
	}],
	columns: [{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_RECRUITING_ORGANIZTION'),
		dataIndex: 'recruitingOrgName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
		dataIndex: 'jobTitle',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('JOB_LOCATIONS'),
		dataIndex: 'jobLocation',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
		dataIndex: 'placementCampus',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STATUS'),
		dataIndex: 'applicationStatus',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				if(value == "APPLIED"){
					return getCommonTranslation('APPLIED');
				}
				else if(value == "SELECTED"){
					return getCommonTranslation('SELECTED');
				}				
			}else{
				return null;
			}
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SELECTION_STAGE'),
		dataIndex: 'selectionStage',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_OFFER_STATUS'),
		dataIndex: 'offerStatus',
		flex:.1,
		sortable:true,
		 renderer:function(value){
			if(!isNullOrEmpty(value))  
				if(value == "PENDING") 
					return getCommonTranslation('PENDING'); 
				else  
					if(value == "OFFERED") 
						return getCommonTranslation('OFFERED'); 
					else 
						 if(value == "REJECTED") 
							return getCommonTranslation('REJECTED'); 
						 else 
							return getCommonTranslation('WAITING'); 
			else 
				return null; 
	}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'),
		dataIndex: 'joiningStatus',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				if(value == "PENDING"){
					return getCommonTranslation('PENDING');
				}
				else if(value == "JOINED"){
					return getCommonTranslation('JOINED');
				}				
			}else{
				return null;
			}
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_LOCATION_SALARY_PACKAGE'),
		dataIndex: 'salaryPkg',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('RESUME'),
		dataIndex: 'documentName',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}else{
				return null;
			}
		}
	},{
		header:  getCommonTranslation('STIPEND'),
		dataIndex: 'stipend',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation('SPONSOR_NAME'),
		dataIndex: 'sponsorName',
		flex:.1,
		sortable:true,
		hidden:true
	}]
});

