/**
 * @author Surendra
 */
Ext.define('Academia.view.program.ProgramCopyWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.programcopywindow',
	modal: true,
	frame: true,
	title:getProgramandcourseTranslation('PROGRAM_COPY_TITLE'),
	//translationKey:'PROGRAM_COPY_TITLE',
	items: [{
		xtype: 'idgeneratorform',
		formCode:'programForm',
		defaults:{
			labelAlign:'top',
			width:226
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'academyLocationId',
				itemId:'academyLocationId',
				fieldLabel: getProgramandcourseTranslation('COPY_PROGRAM_FROM'),
				emptyText: getCommonTranslation('SELECT_ACADEMY_LOCATION'),
				store:'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
				valueField:'id',
				displayField:'value',
				allowBlank:false,
				forceSelection:true,
				triggerAction: 'all',
				minChars:3,
				queryParam:'nameOrCode',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				name : 'programId',
				itemId: 'programId',
				fieldLabel : getProgramandcourseTranslation('PROGRAM'),
				emptyText: getCommonTranslation('SELECT_PROGRAM'),
				store : Ext.create('Academia.store.common.CopyProgramsByAcademyLocationsIds'),
				valueField : 'id',
				displayField : 'value',
				allowBlank:false,
				forceSelection:true,
				triggerAction: 'all',
				minChars:3,
				disabled:true,
				queryParam:'programName',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel: getProgramandcourseTranslation('BATCH'),
				emptyText: getCommonTranslation('SELECT_BATCH'),
				store:'program.programbatchdetail.BatchStore',
				valueField:'id',
				displayField:'value',
				allowBlank:false,
				forceSelection:true,
				typeAhead:false,
				disabled:true,
				queryMode:'local',
				anyMatch:true
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype :'textfield',
				name:'programCode',
				itemId:'programCode',
				fieldLabel: getProgramandcourseTranslation('NEW_PROGRAM_CODE'),
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			},{
				xtype :'textfield',
				name:'newProgramName',
				itemId:'newProgramName',
				fieldLabel: getProgramandcourseTranslation('NEW_PROGRAM_NAME'),
				emptyText: getProgramandcourseTranslation('NEW_PROGRAM_NAME'),
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'succeedingProgramId',
				itemId:'succeedingProgramId',
				fieldLabel: getCommonTranslation('SELECT_SUCCEEDING_PROGRAM'),
				store:'program.SelectSucceedingProgramStoreForLocalSearch',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
			//	editable : true,
				typeAhead:false,
				queryMode:'local',
				anyMatch:true
				
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype :'textfield',
				name:'name',
				itemId:'newBatchName',
				emptyText: getProgramandcourseTranslation('NEW_BATCH_NAME'),
				fieldLabel: getProgramandcourseTranslation('NEW_BATCH_NAME'),
				allowBlank:true
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'batchStartDate',
				itemId : 'batchStartDate',
				endDateField : 'batchTillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'batchTillDate',
				itemId : 'batchTillDate',
				startDateField : 'batchStartDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype :'textfield',
				name:'firstPeriodName',
				itemId:'firstPeriodName',
				emptyText: getProgramandcourseTranslation('FIRST_PERIOD_NAME'),
				fieldLabel: getProgramandcourseTranslation('FIRST_PERIOD_NAME')
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'periodStartDate',
				itemId : 'periodStartDate',
				endDateField : 'periodTillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'periodTillDate',
				itemId : 'periodTillDate',
				startDateField : 'periodStartDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'succeedingBatchId',
				itemId: 'succeedingBatchId',
				fieldLabel : getProgramandcourseTranslation('SUCCEEDING_BATCH'),
				//store : 'program.programbatchdetail.BatchStore',
				valueField : 'id',
				displayField : 'value',
				editable : true,
				typeAhead:false,
				queryMode:'local',
				anyMatch:true,
				forceSelection:true,
				//minChar: 3
			},{
				xtype: 'customcombobox',
				name:'approverId',
				itemId:'approverId',
				store: 'common.AllUserBySmartSearch',
				fieldLabel: getCommonTranslation('APPROVER_DETAILS_COORDINATOR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'btnSubmit',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getProgramandcourseTranslation('BTN_CONTINUE_MANUALLY'),
				formBind:false,
				itemId: 'btnContinue',
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	}]
});
