Ext.define('Academia.view.program.programDetails.programBatchDetails.seatTypes.ProgramSeatTypesGrid', {
	// extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programseattypesgrid',
	store : 'program.programDetails.programBatches.programSeatType.ProgramBatchSeatGridStore',
	title : getCommonTranslation('SEAT_TYPE_GRID'),
	border: true,
	id:'programSeatTypesGridId',
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.programDetails.programBatches.programSeatType.ProgramBatchSeatGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View department
		iconCls: 'view-icon'
			//text : getCommonTranslation('VIEW')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	}],
	columns : [{
		header :getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex : .2,
		sortable : true/*,
		renderer:function(value){
			if(value!=null){
				return value.value; 
			}else{
				return value;
			}
		}*/,
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	}, {
		header : getCommonTranslation('SEATS'),
		dataIndex : 'seatCapacity',
		flex : .2,
		sortable : true,
	//	align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}
	}, {
		header : getCommonTranslation('SEAT_FIELD'),
		dataIndex : 'seatsFilled',
		flex : .2,
		sortable : true,
		summaryType: 'sum',
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}
	}, {
		header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
		dataIndex : 'percentageSeatsFilled',
		flex : .2,
		sortable : true,
		renderer:function(value, rec) {
			return value+'%';
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  summaryData.record.data.percentageSeatsFilled.toFixed(2)+'%';
		}
	}, {
		header : getCommonTranslation('PROCESS'),
		dataIndex : 'processStage',
		flex : .2,
		sortable : true
	},{
		header : getCommonTranslation('BATCH_ENQUIRIES'),
		dataIndex : 'whetherEnableEnquiry',
		flex : .2,
		sortable : true,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			/*metaData.style = "white-space: normal;";
			return getCommonTranslation(value);*/
			if(value==true){
				return 'Yes';
			}else{
				return 'No';
			}
		}
	}	 /*,{
	    header : getCommonTranslation('START_DATE,')
	    dataIndex : 'selProcessStartDate',
	    flex : .2,
	    sortable : true,
	    renderer: function(date) {
            return dateRender(date);
        }
	}, {
	    header : getCommonTranslation('END_DATE'),
	    dataIndex : 'selProcessEndDate',
	    flex : .2,
	    renderer: function(date) {
            return dateRender(date);
        }
	}*/	    
	]
});
