/**
 * @author seshagiri.k
 */
var store = Ext.create('Ext.data.JsonStore', {
    fields: ['name', 'data1'],
    data: [
        {'name':'Applicants', 'data1':772},
        {'name':'Written Test', 'data1':350},
        {'name':'Group Discussion', 'data1':120},
        {'name':'Personal Interview', 'data1':55},
        {'name':'Intake', 'data1':40}                                                
    ]});

Ext.define('Academia.view.program.programDetails.viewHistory.selectionSummary.ProgramSelectionProcessChart' ,{
	extend: 'Ext.chart.Chart',
	alias : 'widget.programSelectionProcessChart',
	plain: true,
	autoScroll: false,
	requires: ['Ext.chart.*', 'Ext.layout.container.Fit', 'Ext.window.MessageBox'],
    animate: true,
    shadow: true,
    width: 400,
    height: 400,
    store: store,
    axes: [{
        type: 'Numeric',
        position: 'left',
        fields: ['data1'],
        title: 'Selection Process',
        grid: true,
        minimum: 0,
        maximum: 1000
    }, {
        type: 'Category',
        position: 'bottom',
        fields: ['name'],
        title: 'Number Of Levels',
        label: {
            rotate: {
                degrees: 270
            }
        }
    }],
    series: [{
        type: 'column',
        axis: 'left',
        gutter: 80,
        xField: 'name',
        yField: ['data1'],
        tips: {
            trackMouse: true,
            width: 140,
            height: 28,
            renderer: function(storeItem, item) {
                this.setTitle(storeItem.get('name'));
                this.update(storeItem.get('data1'));
            }
        },
        style: {
            fill: '#38B8BF'
        }
    }]
});
