/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.program.reports.programreporttab.ProgramReportBasicInfoForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.programreportbasicinfoform',
    autoScroll: false,
    frame: true,
    method: 'POST',
    standardSubmit: false,
    defaults: {
        width: 226,
        labelAlign: 'top'
    },
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '40%',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'panel',
            layout: 'vbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },

            items: [{
                xtype: 'textfield',
                name: 'courseCode',
                readOnly: true,
                fieldLabel: getCommonTranslation('COURSE_CODE')
            }, {
                xtype: 'textfield',
                name: 'courseName',
                fieldLabel: getCommonTranslation('COURSE_NAME')
            }, {
                xtype: 'textfield',
                name: 'nameToBePrinted',
                fieldLabel: getCommonTranslation('NAME_TO_PRINTED')
            }, {
                xtype: 'customcombobox',
                name: 'department',
                itemId: 'courseDepartment',
                fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
                store: 'course.CourseDepartmentStore',
                editable: true,
                valueField: 'id',
                displayField: 'value',
                emptyText: getCommonTranslation('SELECT')
            }, {
                xtype: 'customcombobox',
                name: 'subDepartment',
                itemId: 'courseSubDepartment',
                fieldLabel: getCommonTranslation('COURSE_SUB_DEPARTMENT'),
                store: 'course.CourseSubDepartmentStore',
                editable: true,
                emptyText: getCommonTranslation('SELECT'),
                valueField: 'id',
                displayField: 'value'
            },{
                xtype: 'customcombobox',
                itemId: 'courseCoordinatorId',
                name: 'user',
                fieldLabel: getCommonTranslation('COURSE_CO_ORDINATOR'),
                emptyText: getCommonTranslation('SELECT'),
                store: 'course.CourseCoordinatorStore',
                valueField: 'id',
                displayField: 'nameToBePrinted'
            }]
        }, {
            xtype: 'panel',
            layout: 'vbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'selectionStage',
                itemId: 'stage_Type_Id',
                fieldLabel: getCommonTranslation('STAGE_TYPE'),
                emptyText: getCommonTranslation('SELECT'),
                store: 'course.CourseStageStore',
                valueField: 'id',
                displayField: 'value',
                readOnly: true
            },{
                xtype: 'customcombobox',
                itemId: 'coursePass_Cut_Off',
                fieldLabel: getCommonTranslation('COURSE_PASS_CUT_OFF'),
                name: 'courseCutOffCombo',
                store: 'course.CourseGradeStore',
                displayField: 'code',
                valueField: 'code'
            }, {
                xtype: 'customcombobox',
                itemId: 'course_Max_Mark',
                fieldLabel: getCommonTranslation('COURSE_MAX_MARK'),
                name: 'courseMaxMarkCombo',
                store: 'course.CourseGradeStore',
                displayField: 'code',
                valueField: 'code'
            },{
                xtype: 'numberfield',
                name: 'courseCredits',
                itemId: 'course_Credit_Id',
                fieldLabel: getCommonTranslation('COURSE_CREDITS'),
                minValue: 0,
                readOnly: true,
                allowDecimals:true,
                decimalPrecision: 2
            }, {
                xtype: 'numberfield',
                name: 'courseDeficitsPoint',
                itemId: 'courseDeficitsPointBasicDetailId',
                fieldLabel: getCommonTranslation('COURSE_DEFICITS_POINT'),
                minValue: 0,
                readOnly: true
            }]
        }]
    },{
        xtype: 'radiogroup',
        itemId: 'deficiencyStatusBasicDetail',
        fieldLabel: getCommonTranslation('DEFICIENCY_STATUS'),
        items: [{
            boxLabel: getCommonTranslation('YES'),
            name: 'deficiencyStatus',
            inputValue: true,
            checked: true
        }, {
            boxLabel: getCommonTranslation('NO'),
            name: 'deficiencyStatus',
            inputValue: false
        }]
    }, {
        xtype: 'radiogroup',
        name: 'courseDeficits',
        itemId: 'courseDeficitsBasicDetailId',
        width: 400,
        fieldLabel: getCommonTranslation('COURSE_DEFICITS'),
        items: [{
            boxLabel: getCommonTranslation('FIXED'),
            name: 'courseDeficits',
            inputValue: 'F',
            checked: true
        }]
    }]
});