/**
 * @Author Bhanu P Singh
 */
Ext.define('Academia.view.program.transfercredits.TransferCreditGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.transfercreditgrid',
	store : 'program.transfercredit.TrensferCreditGridStore',
	title: getCommonTranslation('LIST_OF_STUDENT'),
	border: true,
	temp :[],
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.transfercredit.TrensferCreditGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
	columns : [{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header :getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},
	{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},
	{
		header :getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header :getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header :getCommonTranslation('TRANSFER_COURSE'),
		dataIndex : 'courseCount',
		flex:1,
		renderer:function(record){
			if(!isNullOrEmpty(record)){
				return "<a href='#'>"+record+"</a>";
			}else{
				return "-";
			}
		}   
	},{
		header :getCommonTranslation('TRANSFER_CREDITS'),
		dataIndex : 'totalTransferCredit',
		flex:1
	}]
});
