/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.program.uploaddownload.CourseFacultyMappingPBSDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursefacultymappingpbsdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'programId',
				itemId: 'programItemId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				valueField: 'id',
				displayField: 'valueCode',
				width:410,
				minChars:3,
				allowBlank: false,
				forceSelection : true,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId: 'batchItemId',
				fieldLabel: getPersonModuleTranslation('BATCH'),
				disabled:true,
				editable: false,
				width: 226,
				displayField: 'value',
				valueField: 'id',
				store:'enquiry.AcademicBatchStore',
				editable:false
			}]},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					labelAlign: 'top'
				},
				items :[{
					xtype: 'customcombobox',
					name: 'periodId',	      
					itemId:'periodItemId',
					disabled:true,
					width: 226,
					editable: false,
					displayField: 'value',
					valueField: 'id',
					store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					queryMode: 'local',
					fieldLabel: getPersonModuleTranslation('PERIOD')
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					width: 226,
					labelAlign: 'top',
					name : 'sectionId',
					itemId : 'sectionItemId',
					store:'attendance.SectionAndFacultyByPeriodID',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					disabled:true,
					forceSelection : true,
				}]
			},{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign: 'top'
				},
				style :{
					marginTop: '20px'
				},
				items : [{
					xtype: 'fieldcontainer',
					width: 'auto',
					items: [{
						xtype: 'button',
						text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
						itemId: 'downoladBtnId',

						formBind : true,
						ui: 'CustomBtnSubmit'
					},{
						xtype: 'button',
						text: getCourseTxCommonTranslation('RESET'),
						itemId: 'resetBtn',
						buttonAlign: 'left',
						ui: 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					}]}
				]
			}]
	}]
});
