Ext.define('Academia.view.programCourseDashboard.CourseAttendanceGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.courseattendancegrid',
	store : 'programCourseDashboard.CourseAttendanceGridStore',
	title : getProgramandcourseTranslation('COURSE_ATTENDANCE'),
	border: true,
	frame:false,
	refreshStoreData:true,
	id:'courseBatchesGridId',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'programCourseDashboard.CourseAttendanceGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar : ['->',{
		xtype : 'button',
		itemId : 'exportReportsId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		//formBind:true,
		disabled:true
	}],
	columns : [{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_VARIANT_NAME'),
		dataIndex : 'courseVariantName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1,
		hidden:true,
		sortable : true
	},{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermName',
		flex : 1,
		hidden:true,
		sortable : true
	},{
		header :getProgramandcourseTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TOTAL_SESSIONS'),
		dataIndex : 'totalSessions',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TOTAL_PRESENT'),
		dataIndex : 'totalPresent',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TOTAL_ABSENT'),
		dataIndex : 'absents',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('LEAVES'),
		dataIndex : 'leaves',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ATTENDANCE_PERCENTAGE'),
		dataIndex : 'attendancePercentage',
		flex : 1,
		sortable : true
	}]
});