/**
 *
 @author Prashant Choudhary
 */

Ext.define('Academia.view.programCourseDashboard.CourseDetailReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.coursedetailreportsearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
	},
	plugins:"formlabelrequired",
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
            	xtype: 'customcombobox',
            	width:460,
                name: 'courseName',
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            	itemId:'courseCode',
            	store:'coursetransaction.studymaterialdistribution.CoursesByAcademyLocationId',
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'name',
    			minChars:3,
				triggerAction: 'all',
    			allowBlank: true,
    			typeAhead:false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            }
            	}]
        	},
        	{
        		xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [{
        			xtype: 'customcombobox',
        			name: 'department',
        			itemId:'courseDepartment',
        			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
        			store:'department.DepartmentAcademyLocationWiseStore',
        			editable: true,
        			valueField: 'id',
        			displayField: 'value',
        			allowBlank: true,
	    			queryParam:'name',
	    			minChars:3,
					triggerAction: 'all',
					    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            }
        		},{
        			xtype : 'customcombobox',
        			name : 'courseMarkGrade',
        			itemId:'courseMarksGrades_id',
        			fieldLabel : getCommonTranslation('COURSE_MARK_GRADES'),	
        			store:'course.CourseMarkGradeStore',
        			valueField : 'id',
        			displayField : 'value',
        			triggerAction : 'all',
        			editable : false,
        			allowBlank : true
        		}]
        	},
        	{
        		xtype:'fieldcontainer',
        		layout:'hbox',
        		width:'100%',
        		defaults: {
        			width: 226,
        			labelAlign: 'top'
        		},
        		items:[{
        			xtype : 'customcombobox',
        			name : 'sectionType',
        			itemId:'sectionType',
        			fieldLabel : getCommonTranslation('SECTION_TYPE'),		
        			store:'course.SectionTypeStore',
        			valueField : 'id',
        			displayField : 'value',
        			triggerAction : 'all',
        			editable : false,
        			allowBlank : true
        		}]
        		},
        	{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
		            xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: 'right',
		            itemId:'whether_deleted',
		            boxLabel: getCommonTranslation('INCLUDE_DELETED_RECORDS'),
		            name: 'whetherIncludeDeeletedCourses',
		            inputValue : true,
		            uncheckedValue: false 
		        }]
        	}, {
            xtype: 'fieldcontainer',
            width: 'auto',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
            	 xtype: 'button',
                 text: getCommonTranslation('RESET'),
                 itemId: 'resetBtn',
                 ui: 'CustomBtnCancel',
                 scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});