/**
 * @author Ravi Choudhary
 */

var CourseRosterReportStore = Ext.create('Academia.store.programCourseDashboard.CourseRosterReportStore');
Ext.define('Academia.view.programCourseDashboard.CourseRosterReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.courserosterreportgrid',
	store: CourseRosterReportStore,
	title: getExaminationTranslation('COURSE_ROSTER_REPORT'),
	border: true,
	refreshStoreData:true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : CourseRosterReportStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	tbar: [	{
		xtype : 'button',
		itemId:'sendMessageBtn',
		text : getCommonTranslation('SEND_MESSAGE'),
		tooltip :getCommonTranslation('SEND_MESSAGE')
	}, {
		xtype : 'button',
		itemId:'resetPasswordBtn',
		text : getCommonTranslation('RESET_PASSWORD'),
		tooltip :getCommonTranslation('RESET_PASSWORD'),
		disabled:true
	},'->',{
		xtype : 'button',
		itemId : 'exportCourseRosterReportsId',
		tooltip : getExaminationTranslation('EXPORT_COURSE_ROSTER_REPORT'),
		text : getExaminationTranslation('EXPORT_COURSE_ROSTER_REPORT'),
		disabled:true
	}],
	columns: [{
		header:  getProgramandcourseTranslation('COURSE_CATEGORY'),
		dataIndex: 'courseCategory',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('COURSE'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_TYPE'),
		dataIndex : 'whetherOptional',
		flex:.12,
		hidden:true,
		sortable : true,
		renderer:function(v){
			if(v){
				return 'Optional';
			}else{
				return 'Mandatory'; 
			}    		
		}
	},{
		header:  getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			var baseController=Academia.app.getController('Academia.controller.base.BaseController');
			if(!isNullOrEmpty(value)) {
				return '<a href=#>'+value+'</a>'
			}                        
		}
	},{
		header:  getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true,
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .1
	}, {
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex : .1,
		hidden :true
	},{
		header:  getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('SECTION'),
		dataIndex: 'pbsSectionName',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation('EXAMBOARDNUMBER'),
		dataIndex: 'boardNumber',
		flex:.1,
		hidden :true,
		sortable:true
	},{
		header:  getCommonTranslation('ENROLLMENT_DATE'),
		dataIndex: 'enrollmentDate',
		flex:.1,
		renderer:function(enrollmentDate) {
			return dateRender(enrollmentDate);
		},
		sortable:true
	},{
		header:  getProgramandcourseTranslation('PRIMARY_FACULTY'),
		dataIndex: 'facultyName',
		flex:.1,
		renderer:function columnWrap(val, metaData){
			return val;
		}
	},{
		header: getPersonModuleTranslation('ALTERNATE_FACULTY'),
		dataIndex: 'alternativeFaculty',
		sortable:true,
		flex: .1,
		hidden :true
	},{
		header:  getCourseTxCommonTranslation('EMAIL_ID'),
		dataIndex: 'emailId',
		flex:.1,
		sortable:true
	},{
		header:  getCourseTxCommonTranslation('PHONE_NO'),
		dataIndex: 'mobileNumber',
		flex:.1,
		sortable:true
	}, {
		text : getAdmissionTranslation('DOB'),
		dataIndex : 'birthDate',
		sortable : true,
		flex:.1,
		hidden:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return dateRender(value);
			}
			else{
				return '';
			}
		}
	}, {
		text : getAdmissionTranslation('FATHER_NAME'),
		dataIndex : 'fatherName',
		sortable : true,
		flex:.1,
		hidden:true
	}, {
		text : getCommonTranslation('MOTHERS_NAME'),
		dataIndex : 'motherName',
		sortable : true,
		flex:.1,
		hidden:true
	},{
		text : getCommonTranslation('INTAKE_YEAR'),
		dataIndex : 'intakeYear',
		sortable : true,
		flex:.1
	},{
		text : getAdmissionTranslation('ID_NUMBER'),
		dataIndex : 'nationalID',
		sortable : true,
		flex:.1
	},{
		text : getAdmissionTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		sortable : true,
		flex:.1
	},{
		text : getCommonTranslation('EXAM_CENTER'),
		dataIndex : 'examCenterValue',
		sortable : true,
		flex:.1
	}]
});
