/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.programCourseDashboard.DailyLogOrSessionCBSReportFilter', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.dailylogorsessioncbsreportfilter',
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults :{
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'ACADEMIC_TERM',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank:true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.AcademicTermByPeriodIdsStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
				name : 'sectionGroupId',
				itemId : 'sectionGroupId',
//				store : 'coursetransaction.sectionmanagement.SectionGroup',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				listeners  :{
	            	render : function(combo){
	            		  var store=Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroup');
	            		  combo.bindStore(store)
	            	}
	            }
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'datefield',
				name:'fromDate',
				itemId:'fromDate',
				fieldLabel:getProgramandcourseTranslation('FROM_DATE'),
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'toDateId',
				editable:false,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'courseCBSId',
				itemId: 'courseCBSId',
//				store:'attendance.CoursesByAcademyLocationIds',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey:'COURSE',
				valueField: 'courseId',
				displayField: 'courseCodeName',
				queryParam:'name',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				width:226,
//				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners: {
					render: function(combo) {
//						var store = Ext.create('Academia.store.attendance.CoursesByAcademyLocationIds');
						var store = Ext.create('Academia.store.course.AssignedPeriodCoursesFacultyStore');
						combo.bindStore(store);
					}
				}
			},
			{
				xtype: 'customcombobox',
				name: 'courseCBSId1',
				itemId: 'courseCBSId1',
//				store:'attendance.CoursesByAcademyLocationIds',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey:'COURSE',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				store : 'attendance.attendancereport.CourseByStudentId',
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				hidden:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				width:226,
//				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}]
		},
		{
			xtype:'fieldset',
			title:getServiceRequestTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top',
			},
			style: {
				marginTop: '40px!important',
			},
			items:[{
				xtype:'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				style:{
//					marginTop:'40px!important'
				},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
					name : 'componentId',
					itemId : 'componentId',
					displayField : 'componentTypeName',
					valueField : 'id',
					typeAhead : true,
					disable:true,
					forceSelection : true,
					hidden:true
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
//					translationKey:'COURSE_VARIANT',
					name : 'courseVariantCBSId',
					itemId : 'courseVariantCBSId',
//					store:'course.coursevariants.CourseVariantStore',
					displayField : 'code',
					valueField : 'id',
					typeAhead : false,
					forceSelection : true,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.coursetransaction.sectionmanagement.CoruseVariantSectionStore')
							//var store=Ext.create('Academia.store.course.coursevariants.CourseVariantStore');
							combo.bindStore(store)
						}
		            }
				},{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('FACULTY'),
//					translationKey:'FACULTY',
					name: 'facultyCBSId',
					itemId:'facultyCBSId',
//					store:'common.ActiveUserStore',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					},
					listeners  :{
		            	render : function(combo){
		            		  var store=Ext.create('Academia.store.common.ActiveUserStore');
		            		  combo.bindStore(store)
		            	}
		            }
				},{
					xtype: 'datefield',
					name:'toDateId',
					itemId:'toDateId',
					fieldLabel:getServiceRequestTranslation('TO_DATE'),
					vtype: 'daterange',
					startDateField: 'fromDate',
					editable:false,
					//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
	            	  render: function(field) {
	            		  return dateFormatRender(field);
	            	  }
	              },
				}]
		
			}]
		}
		
		
		
		,{
			xtype: 'fieldcontainer',
			width: '100%',

			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'btnSearch',
				buttonAlign: 'left',
				formBind : true,
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE               
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]

});