/**
 * @author Dharmendra.p
 */
Ext.define('Academia.view.programCourseDashboard.ProgramDetailsReportSearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.programdetailsreportsearch',
	autoScroll: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	frame: false,
	items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults :{
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype : 'multiselectcombofield',
				name : 'programId',
				itemId : 'programId',     
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				autoloadStore: false,
				width: 460,
				store : 'common.ProgramsByAcademyLocationsIds',
				displayField : 'valueCode',
				valueField : 'id',
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				cls:'commonAutoHeightMultiselectField',
				allowBlank : false,
				hidden : false,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),		
			name : 'batchId',
			itemId : 'batchId',
			disabled:true,
			store : 'enquiry.AcademicBatchStore',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true
		}]
	},{
		xtype:'displayfield',
		name:'displayEntryExit',
		value:'<b class="menu-title">'+getProgramandcourseTranslation('PROGRAM_BATCH_REPORT_DATE')+'</b>',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults :{
			labelAlign:'top',
			width:226
		},
		items: [{
		xtype : 'datefield',
		fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
		name : 'fromDate',
		itemId:'fromDate',	
		endDateField : 'toDate',
		listeners: {
			render: function(field) {
				return dateFormatRender(field);
			}
		},
		//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
		vtype : 'daterange'
	},{
		xtype : 'datefield',
		fieldLabel : getProgramandcourseTranslation('TO_DATE'),
		name : 'toDate',
		itemId:'toDate',
		startDateField : 'fromDate',
		listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
		vtype : 'daterange'
	}
	]},{
		xtype: 'fieldcontainer',
		width: '100%',
		
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'btnSearch',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'btnReset',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]	
});
