/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.quartz.QuartzList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.quartzlist',
	store : 'quartz.QuartzJobList',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'quartz.QuartzJobList',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getCommonTranslation('JOB_NAME'),
		dataIndex : 'jobName',
		flex:1
	},{
		header : getCommonTranslation('START_DATE'),
		dataIndex : 'startDateTime',
		flex:1,
		renderer: function(dateTime) {
			return dateRender(dateTime)+" "+timeRender(dateTime);
		}
	},{
		header : getCommonTranslation('END_DATE'),
		dataIndex : 'endDateTime',
		flex:1,
		renderer: function(dateTime) {
			return dateRender(dateTime)+" "+timeRender(dateTime);
		}
	},{
		header : getCommonTranslation('USER'),
		dataIndex : 'triggeredBy',
		flex:1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	},{
		header : getCommonTranslation('REPORT'),
		dataIndex : 'report',
		flex:1, 
		renderer: function(value) {  
			if(!isNullOrEmpty(value))
			return '<a href=#>' + "Report" + '<a>';
		}
	}]
});