/**
 * @author Amit G
 *
 */
Ext.define('Academia.view.receipt.receiptsettings.BillSettingsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.billsettingsgrid',
    store: 'receipt.receiptsettings.BillSettingsStore',
    title: getFeeAndPaymentCommonTranslation('BILL_SETTINGS'),
    border: true,
     sortable: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'receipt.receiptsettings.BillSettingsStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && !isNullOrEmpty(value.value)) {
                return value.value;
            }
            return '';
        }
    }, {
        header: getCommonTranslation('RS_BACK_DATE_DAYS'),
        dataIndex: 'backDateAllowInDays',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('RS_FUTURE_DATE_DAYS'),
        dataIndex: 'futureDateAllowInDays',
        flex: 1,
        sortable: true
    }, {
        header: getFeeAndPaymentCommonTranslation('SHOW_ADDITIONAL_COLUMNS'),
        dataIndex: 'showAdditionalColumns',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && value == true) {
                return 'Yes';
            }else{
            	return 'No';
            }
        }
    },{
        header: getFeeAndPaymentCommonTranslation('DUE_DATE_EDITABLE'),
        dataIndex: 'whetherDueDateEditable',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && value == true) {
                return 'Yes';
            }else{
            	return 'No';
            }
        }
    },{
        header: getCommonTranslation('BILL_GENERATION_ON_SUBMIT_APPLICATION'),
        dataIndex: 'billGenerationOnSubmitApplication',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && value == true) {
                return 'Yes';
            }else{
            	return 'No';
            }
        }
    }]
});