/**
 * @author Deepak S
 */
var gridStore = Ext.create('Academia.store.registrationsetup.CourseRegistrationGridStore');
Ext.define('Academia.view.registrationsetup.CourseRegistrationEditableGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.courseregistrationeditablegrid',
    store: gridStore,
    title: getCommonTranslation('REGISTRATION_TERM'),
    border: true,
    cls:'clsAssigneeApproverGrid',
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
        emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    //isGridConfigurable: true,
    enableColumnHide: false,
    /*tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		itemId: 'fldContSaveItemId',
		hidden:true,
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveMapCourseItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
			//formBind : true
		}]
	}],*/
    columns: [{
        header: getCommonTranslation('REGISTRATION_TERM'),
        dataIndex: 'registrationTerm',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	itemId: 'registrationTermId',
        	name: 'registrationTerm', 
        	store:'registrationsetup.RegistrationTermGridComboStore',
        	valueField:'id',
        	displayField:'value',
        	typeAhead:false,
        	forceSelection:true,
        	queryParam:'qry',
        	listeners: {
    			/*blur: function(combo, r) {
    				combo.getStore().load();
    			},*/
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				//var form = Ext.ComponentQuery.query('mapcoursespncform')[0];
    				//var values = form.getValues();

    				combo.getStore().load();
    			},
    			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('courseregistrationeditablegrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				var flag = true;
        				var itms = grid.getStore().data.items;
        				itms.forEach(function(object){
        					if(object.data.registrationTerm  == record[0].data.id ){
        						flag = false;
        						return false;
        					}
        				});
        				if(flag){
        					if(!isNullOrEmpty(selectedRecord.data.id)){
        						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        					}else{
        						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        					}
        				}else{
        					this.reset();
        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REGISTRATION_TERM_ALREADY_SELECTED'));
        					return false;
        				}
        			}
        	 }
        },
        listeners: {
        	render: function(combo){
        		if(!isNullOrEmpty(combo)){
        			combo.getEditor().store.load();
        		}
        	}
        },
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('registrationTerm')) && isNullOrEmpty(record.get('registrationTerm'))){
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
    			else{
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('registrationTerm');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    		}
    	}
    },{
        header: getCommonTranslation('ADMIN_START_DATE'),
        dataIndex: 'adminStartDate',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'adminStartDate',
            itemId: 'adminStartDateId',
            listeners: {
            	render: function(field) {
            		var grid = field.up('grid');
            		var adminStartDate = grid.down('#adminStartDateId');
            		var record = grid.getSelectionModel().getSelection()[0];
					if(!isNullOrEmpty(record.data.periodStartDate)){
						adminStartDate.setMinValue(record.data.periodStartDate);
					}
					if(!isNullOrEmpty(record.data.periodEndDate)){
						adminStartDate.setMaxValue(record.data.periodEndDate);
					}
					
					return dateFormatRender(field);
				},
				change:function(field, newValue, oldValue){
					var me = this;
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					if(!isNullOrEmpty(record.data.adminEndDate)){
						if(!record.data.isEditCourseReg){
						if(record.data.adminEndDate.getTime() > newValue.getTime()){
							record.set('studentStartDate',newValue);
						}
						else{
							record.set('studentStartDate',record.data.adminStartDate);
						}
						}
					}
					else{
						record.set('studentStartDate',newValue);
					}
					
				}
				/*select: function(field, value, eOpts) {
					
					var editPlugin = this.up().editingPlugin;
					var curCol = editPlugin.context.colIdx;
					var rowIdx = editPlugin.context.rowIdx;
					//var nextcolumnEditor = editPlugin.activeColumn.nextNode().getEditor();

					if(!isNullOrEmpty(editPlugin)){
						var adminEndDate = editPlugin.activeColumn.nextNode().nextNode()
						var nextcolumnEditor = adminEndDate.getEditor();
						nextcolumnEditor.setMinValue(value);
					}

					var models = grid.getStore().getRange();
					if(!isNullOrEmpty(nextcolumnEditor)){
						models[rowIdx].set("courseId", null);
						models[rowIdx].set("courseReadingId", null);
						nextcolumnEditor.setValue(null);
					}
                }*/
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
            /*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.adminStartDate)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.adminStartDate)) {
                    val = record.data.adminStartDate;
                }
                models[rowIndex].set("adminStartDate", val);
                return dateRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('ADMIN_START_TIME'),
        dataIndex: 'adminStartTime',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'timefield',
            name: 'adminStartTime',
            itemId: 'adminStartTimeId',
            format:'g:i A',                
			increment: 15,
            submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
            listeners: {
            	focus: function(combo, eOpt) {
                	if (!isNullOrEmpty(combo.getValue())) {
                		combo.setRawValue(timeRender(combo.getValue()));
                	}
                	else{
                		var adminStartTime = combo.up('courseregistrationeditablegrid').getSelectionModel().getSelection()[0].data.adminStartTime;
                		if (!isNullOrEmpty(adminStartTime)) {
                			combo.setRawValue(timeRender(adminStartTime));
                		}
                	}
                },
                change:function(field, value, eOpts){
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					record.set('studentStartTime',value);
				}
                /*render: function(field) {
                	return timeFormatRender(field);
                }*/
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = timeRender(val);
        	if(dateVal == "NaN:NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		return timeRender(val);
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
            /*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.adminStartTime)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.adminStartTime)) {
                    val = record.data.adminStartTime;
                }
                models[rowIndex].set("adminStartTime", val);
                return timeRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('ADMIN_END_DATE'),
        dataIndex: 'adminEndDate',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'adminEndDate',
            itemId: 'adminEndDateId',
            listeners: {
                render: function(field) {
                	var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					var adminEndDate = grid.down('#adminEndDateId');
					if(!isNullOrEmpty(record.data.periodStartDate)){
						adminEndDate.setMinValue(record.data.periodStartDate);
					}
					if(!isNullOrEmpty(record.data.periodEndDate)){
						adminEndDate.setMaxValue(record.data.periodEndDate);
					}
                    return dateFormatRender(field);
                },
                change:function(field, newValue, oldValue){ 
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					if(!record.data.isEditCourseReg){
						if(record.data.adminStartDate.getTime() >newValue.getTime()){
							record.set('studentEndDate',oldValue);
						}
						else{
							record.set('studentEndDate',newValue);
						}
					}
					
				}
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
        	/*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.adminEndDate)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.adminEndDate)) {
                    val = record.data.adminEndDate;
                }
                models[rowIndex].set("adminEndDate", val);
                return dateRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('ADMIN_END_TIME'),
        dataIndex: 'adminEndTime',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'timefield',
            name: 'adminEndTime',
            itemId: 'adminEndTimeId',
            format:'g:i A',                
			increment: 15,
            submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
            listeners: {
            	focus: function(combo, eOpt) {
                	if (!isNullOrEmpty(combo.getValue())) {
                		combo.setRawValue(timeRender(combo.getValue()));
                	}
                	else{
                		var adminEndTime = combo.up('courseregistrationeditablegrid').getSelectionModel().getSelection()[0].data.adminEndTime;
                		if (!isNullOrEmpty(adminEndTime)) {
                			combo.setRawValue(timeRender(adminEndTime));
                		}
                	}
                },
                change:function(field, value, eOpts){
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					record.set('studentEndTime',value);
				}
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = timeRender(val);
        	if(dateVal == "NaN:NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		return timeRender(val);
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
            /*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.adminEndTime)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.adminEndTime)) {
                    val = record.data.adminEndTime;
                }
                models[rowIndex].set("adminEndTime", val);
                return timeRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('STUDENT_START_DATE'),
        dataIndex: 'studentStartDate',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'studentStartDate',
            itemId: 'studentStartDateId',
            listeners: {
                render: function(field) {
                	var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					var studentStartDate = grid.down('#studentStartDateId');
					if(!isNullOrEmpty(record.data.studentPeriodStartDate)){
						studentStartDate.setMinValue(record.data.studentPeriodStartDate);
					}
					if(!isNullOrEmpty(record.data.studentPeriodEndDate)){
						studentStartDate.setMaxValue(record.data.studentPeriodEndDate);
					}
                    return dateFormatRender(field);
                },
                change:function(field, newValue, oldValue){
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					if(record.data.studentEndDate.getTime() < newValue.getTime()){
						record.set('studentStartDate',newValue);
					}
					
				}
				/*select: function(field, value, eOpts) {
					
					var editPlugin = this.up().editingPlugin;
					//var curCol = editPlugin.context.colIdx;
					//var rowIdx = editPlugin.context.rowIdx;
					//var nextcolumnEditor = editPlugin.activeColumn.nextNode().getEditor();

					if(!isNullOrEmpty(editPlugin)){
						var studentEndDate = editPlugin.activeColumn.nextNode().nextNode()
						var nextcolumnEditor = studentEndDate.getEditor();
						nextcolumnEditor.setMinValue(value);
					}

					var models = grid.getStore().getRange();
					if(!isNullOrEmpty(nextcolumnEditor)){
						models[rowIdx].set("courseId", null);
						models[rowIdx].set("courseReadingId", null);
						nextcolumnEditor.setValue(null);
					}
                }*/
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
        	/*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.studentStartDate)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.studentStartDate)) {
                    val = record.data.studentStartDate;
                }
                models[rowIndex].set("studentStartDate", val);
                return dateRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('STUDENT_START_TIME'),
        dataIndex: 'studentStartTime',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'timefield',
            name: 'studentStartTime',
            itemId: 'studentStartTimeId',
            format:'g:i A',
			increment: 15,
            submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
            listeners: {
            	focus: function(combo, eOpt) {
                	if (!isNullOrEmpty(combo.getValue())) {
                		combo.setRawValue(timeRender(combo.getValue()));
                	}
                	else{
                		var studentStartTime = combo.up('courseregistrationeditablegrid').getSelectionModel().getSelection()[0].data.studentStartTime;
                		if (!isNullOrEmpty(studentStartTime)) {
                			combo.setRawValue(timeRender(studentStartTime));
                		}
                	}
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = timeRender(val);
        	if(dateVal == "NaN:NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		return timeRender(val);
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
            /*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.studentStartTime)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.studentStartTime)) {
                    val = record.data.studentStartTime;
                }
                models[rowIndex].set("studentStartTime", val);
                return timeRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('STUDENT_END_DATE'),
        dataIndex: 'studentEndDate',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'studentEndDate',
            itemId: 'studentEndDateId',
            listeners: {
                render: function(field) {
                	var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					var studentEndDate = grid.down('#studentEndDateId');
					if(!isNullOrEmpty(record.data.studentPeriodStartDate)){
						studentEndDate.setMinValue(record.data.studentPeriodStartDate);
					}
					if(!isNullOrEmpty(record.data.studentPeriodEndDate)){
						studentEndDate.setMaxValue(record.data.studentPeriodEndDate);
					}
                    return dateFormatRender(field);
                },
                change:function(field, newValue, oldValue){
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					if(record.data.studentStartDate.getTime() > newValue.getTime()){
						record.set('studentEndDate',oldValue);
					}
				}
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
        	/*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.studentEndDate)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.studentEndDate)) {
                    val = record.data.studentEndDate;
                }
                models[rowIndex].set("studentEndDate", val);
                return dateRender(val);
            }*/
        }
    },{
        header: getCommonTranslation('STUDENT_END_TIME'),
        dataIndex: 'studentEndTime',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'timefield',
            name: 'studentEndTime',
            itemId: 'studentEndTimeId',
            format:'g:i A',                
			increment: 15,
            submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
            listeners: {
            	focus: function(combo, eOpt) {
                	if (!isNullOrEmpty(combo.getValue())) {
                		combo.setRawValue(timeRender(combo.getValue()));
                	}
                	else{
                		var studentEndTime = combo.up('courseregistrationeditablegrid').getSelectionModel().getSelection()[0].data.studentEndTime;
                		if (!isNullOrEmpty(studentEndTime)) {
                			combo.setRawValue(timeRender(studentEndTime));
                		}
                	}
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = timeRender(val);
        	if(dateVal == "NaN:NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		return timeRender(val);
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
            /*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.studentEndTime)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.studentEndTime)) {
                    val = record.data.studentEndTime;
                }
                models[rowIndex].set("studentEndTime", val);
                return timeRender(val);
            }*/
        }
    },{
		header : getCommonTranslation('ALLOW_ADD'),
		dataIndex:'whetherAllowAdd', 
		stopSelection: false, 
		flex: 0.5,
        renderer: function(value, meta, record) {
        	var indx = record.index;
        	var recVal = record.data.whetherAllowAdd;
        	var dataIndx = meta.column.dataIndex;
        	var val =false;
        	if(recVal == dataIndx){
        		val = true;
        	}
        	return '<center><input type="checkbox" style="width:15px;height:15px;" '+(value ? 'checked="true"' : '')+' ></center>';
        }
	},{
		header : getCommonTranslation('ALLOW_DROP'),
		dataIndex:'whetherAllowDrop', 
		stopSelection: false, 
		flex: 0.5,
        renderer: function(value, meta, record) {
        	var indx = record.index;
        	var recVal = record.data.whetherAllowDrop;
        	var dataIndx = meta.column.dataIndex;
        	var val =false;
        	if(recVal == dataIndx){
        		val = true;
        	}
        	return '<center><input type="checkbox" style="width:15px;height:15px;" '+(value ? 'checked="true"' : '')+' ></center>';
        }
	},{/*
		header : getCommonTranslation('LATE_FEE'),
		dataIndex:'whetherAllowLateFee', 
		stopSelection: false, 
		flex: 0.5,
        renderer: function(value, meta, record)
        {
        	var indx = record.index;
        	var recVal = record.data.whetherAllowLateFee;
        	var dataIndx = meta.column.dataIndex;
        	var val =false;
        	if(recVal == dataIndx){
        		val = true;
        	}
        	return '<center><input type="checkbox" style="width:15px;height:15px;" '+(value ? 'checked="true"' : '')+' ></center>';
        }
	*/
		header : getCommonTranslation('LATE_FEE'),
		dataIndex:'lateFeeConfigurationSetUp', 
		flex: 0.6,
        renderer: function(value, meta, record) {
        	if(!isNullOrEmpty(record.data.lateFeeConfigurationSetUp)){
        		if(record.data.lateFeeConfigurationSetUp.length>0){
            		if(record.data.lateFeeConfigurationSetUp[0].whetherActive==true)
            		  return '<a href="#" style = "color:#009e0f;">'+getCommonTranslation('ACTIVE')+'</a>';
            		else if(record.data.lateFeeConfigurationSetUp[0].whetherActive==false)
            			return '<a href="#" style = "color:#cc0000;">'+getCommonTranslation('INACTIVE')+'</a>';
            	}
        	}
        	if(!isNullOrEmpty(record.data.whetherAllowLateFee)){
        		if(record.data.whetherAllowLateFee == true){
        			return '<a href="#" style = "color:#009e0f;">'+getCommonTranslation('ACTIVE')+'</a>';
        		}else if(record.data.whetherAllowLateFee == false && record.data.lateFeeConfigurationSetUp.length>0){
        			return '<a href="#" style = "color:#cc0000;">'+getCommonTranslation('INACTIVE')+'</a>';
        		}
        	}
        	return '<a href="#">'+getCommonTranslation('CONFIGURE')+'</a>';
        }
	 }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow)
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
            	if(rowIndex>0){
            		return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";	
            	}
            }
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            edit: function(editor, e, context) {
            	var rowData = e.record.data;
            	var grid = e.grid;
            	grid.up('tabpanel').down('#submitCourseRegistrationBtn').isValid = true;
                var models = grid.getStore().getRange();
                var registrationController = Academia.getApplication().getController('Academia.controller.registrationsetup.RegistrationTermSetupController');
                if(e.field == "studentStartDate" || e.field == "studentEndDate" || e.field == "studentStartTime" || e.field == "studentEndTime"){
                	if (!isNullOrEmpty(rowData.studentStartDate) && !isNullOrEmpty(rowData.studentEndDate) && !isNullOrEmpty(rowData.studentStartTime) && !isNullOrEmpty(rowData.studentEndTime)) {
                       
                		var combinedInTimeDate = registrationController.CombineDateAndTime(rowData.studentStartDate,rowData.studentStartTime);
                        var inTimeInMiliSeconds = combinedInTimeDate.getTime();
                        var combinedOutTimeDate = registrationController.CombineDateAndTime(rowData.studentEndDate,rowData.studentEndTime);
                        var outTimeInMiliSeconds = combinedOutTimeDate.getTime();
                        var timeDiff = outTimeInMiliSeconds - inTimeInMiliSeconds;
                        
                        if(timeDiff < 0 ){
                        	grid.up('tabpanel').down('#submitCourseRegistrationBtn').isValid = false;
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('STUDENT_DATE_TIME_COMPARE_MSG'));
                        	models[e.rowIdx].set(e.field,e.originalValue);
                        }
                    }
                }else if(e.field == "adminStartTime" || e.field == "adminEndTime" || e.field == "adminStartDate" || e.field == "adminEndDate"){
                	if (!isNullOrEmpty(rowData.adminStartDate) && !isNullOrEmpty(rowData.adminEndDate) && !isNullOrEmpty(rowData.adminStartTime) && !isNullOrEmpty(rowData.adminEndTime)) {
                        /*var inTimeDate = new Date(rowData.adminStartTime);
                        inTimeDate.setFullYear(1970);
                        var inTimeInMiliSeconds = inTimeDate.getTime();
                        var outTimeDate = new Date(rowData.adminEndTime);
                        outTimeDate.setFullYear(1970);
                        var outTimeInMiliSeconds = outTimeDate.getTime();
*/
                        var combinedInTimeDate = registrationController.CombineDateAndTime(rowData.adminStartDate,rowData.adminStartTime);
                        var inTimeInMiliSeconds = combinedInTimeDate.getTime();
                        var combinedOutTimeDate = registrationController.CombineDateAndTime(rowData.adminEndDate,rowData.adminEndTime);
                        var outTimeInMiliSeconds = combinedOutTimeDate.getTime();
                        var timeDiff = outTimeInMiliSeconds - inTimeInMiliSeconds;
                        if(timeDiff < 0 ){
                        	grid.up('tabpanel').down('#submitCourseRegistrationBtn').isValid = false;
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ADMIN_DATE_TIME_COMPARE_MSG'));
                        	models[e.rowIdx].set(e.field,e.originalValue);
                        }
                    }	
                }
            }
        }
    }]
});