/**
 *  @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.registrationsetup.RegistrationRulesTabRegistrationSetupDetails' ,{
	extend: 'Ext.panel.Panel',
	alias : 'widget.registrationrulestabregistrationsetupdetails',
	width:'100%',
	autoScroll: false,
	height: 900,
	bodyStyle:{
		border: 0
	},
	bodyPadding:'5 5 5 5',
	items:[{
		xtype: 'grid',
		store: 'registrationsetup.RegistrationSetupRulesGridStore',
		border: true,
		autoScroll: false,
		overflowX: 'scroll',
		cls:'registrationRulesGridCls',
		width:'100%',
		height: 790,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		style:{
			marginLeft:'0px'
		},
		selType:'checkboxmodel',
		selModel: {
			multiSelect :true,
			mode:'SIMPLE',
			checkOnly : true,
			injectCheckbox:1
		},
		columns: [{
			header: getCommonTranslation('REGISTRATION_RULES'),
			dataIndex: 'code',
			sortable:false,
			flex: 0.3,
			menuDisabled: true,
			renderer: function(val){
				if(!isNullOrEmpty(val)){
					return getCommonTranslation(val);
				}
				return '';
			}
		},
		{
			flex: 1,
			menuDisabled: true,
			renderer: function(val,meta,rec) {
				if(rec.get('code') == "COURSE_GROUP"){
					var id = Ext.id();
					Ext.defer(function() {
						Ext.widget('container', {
							renderTo: Ext.query("#"+id)[0],
							width: '100%',
							itemId: 'yearlyGroupPanel',
							layout: 'hbox',
							items:[{
								xtype: 'numberfield',
								itemId: 'minNumberCourseGroupField',
								maxValue: 99,
								minValue: 1,
								width: 340,
								labelWidth: 200,
								fieldLabel: getCommonTranslation('MINIMUM_NUMBER_OF_COURSE_GROUP'),
								emptyText: getCommonTranslation('MINIMUM_NUMBER_OF_COURSE_GROUP'),
								validator : function(val) {
									try{
										var maxValuefield = Ext.ComponentQuery
										.query('numberfield#maxNumberCourseGroupField')[Ext.ComponentQuery
											.query('numberfield#maxNumberCourseGroupField').length-1];
										var maxValue = maxValuefield
										.getValue();
										if (maxValue != null) {
											if (val <= maxValue) {
												maxValuefield
												.clearInvalid();
												return true;
											} else {
												return 'Less than max course group';
											}
										} else {
											return true;
										}
									}catch(e){
										return true;
									}
								}
							},{
								xtype: 'numberfield',
								itemId: 'maxNumberCourseGroupField',
								maxValue: 99,
								minValue: 1,
								width: 340,
								labelWidth: 200,
								margin: '0 0 0 20',
								fieldLabel: getCommonTranslation('MAX_NUMBER_OF_COURSE_GROUP'),
								emptyText: getCommonTranslation('MAX_NUMBER_OF_COURSE_GROUP'),
								validator : function(val) {
									try{
										var minValueField = Ext.ComponentQuery
										.query('numberfield#minNumberCourseGroupField')[Ext.ComponentQuery
											.query('numberfield#minNumberCourseGroupField').length-1];
										var minValue = minValueField
										.getValue();
										if (minValue != null) {
											if (val >= minValue) {
												minValueField
												.clearInvalid();
												return true;
											} else {
												return 'More than min course group';
											}

										} else {
											return true;
										}
									}
									catch(e){
										return true;
									}
									
								}
							}]
						});
					}, 50);
					return Ext.String.format('<div id="{0}"></div>', id);
				}
				else if(rec.get('code') == "YEARLY_REGISTRATIONS_APPLICABLE"){
					var id = Ext.id();
					Ext.defer(function() {
						Ext.widget('container', {
							renderTo: Ext.query("#"+id)[0],
							width: 1000,
							itemId: 'yearlyFieldsPanel',
							layout: 'hbox',
							items:[{
								xtype: 'numberfield',
								maxValue: 9999,
								minValue: 1,
								width: 200,
								labelWidth: 120,
								itemId: 'minNumberOfCreditYearly',
								fieldLabel: getCommonTranslation('MINIMUM_NUMBER_OF_CREDIT'),
								emptyText: getCommonTranslation('MINIMUM_NUMBER_OF_CREDIT'),
								mouseWheelEnabled: false,
							},{
								xtype: 'numberfield',
								maxValue: 999,
								minValue: 0,
								width: 200,
								labelWidth: 120,
								margin: '0 0 0 10',
								itemId: 'maxRegularCourseCreditYearly',
								fieldLabel: getCommonTranslation('MAXIMUM_NUMBER_OF_REGULAR_COURSE_CREDIT'),
								emptyText: getCommonTranslation('MAXIMUM_NUMBER_OF_REGULAR_COURSE_CREDIT'),
								mouseWheelEnabled: false,
							},{
								xtype: 'numberfield',
								maxValue: 999,
								minValue: 0,
								width: 250,
								labelWidth: 180,
								margin: '0 0 0 10',
								itemId: 'maxOtherCourseCreditYearly',
								fieldLabel: getCommonTranslation('MAXIMUM_NUMBER_OF_OTHER_COURSE_CREDIT'),
								emptyText: getCommonTranslation('MAXIMUM_NUMBER_OF_OTHER_COURSE_CREDIT'),
								mouseWheelEnabled: false,
							},{
								xtype: 'numberfield',
								maxValue: 9999,
								minValue: 1,
								width: 180,
								labelWidth: 100,
								margin: '0 0 0 10',
								itemId: 'maxNumberOfCreditYearly',
								fieldLabel: getCommonTranslation('MAXIMUM_NUMBER_OF_CREDIT_NEW'),
								emptyText: getCommonTranslation('MAXIMUM_NUMBER_OF_CREDIT_NEW'),
								mouseWheelEnabled: false,
								enableKeyEvents: true
							}]
						});
					}, 50);
					return Ext.String.format('<div id="{0}"></div>', id);
				}
				else{
					return '';
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		style:{
			marginBottom:'5px'
		},
		items: [{
			xtype : 'button',
			text : getCommonTranslation("NEXT") ,
			itemId : 'nextRegistrationRulesAdditionalSetupBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'submitRegistrationRulesAdditionalSetupBtn',
			text: getCommonTranslation("SUBMITKYS"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		}]
	}]
});

