/**
\ * This view is used for Admission Rejection Analysis Search Form
 * 
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.admission.dashboard.AdmissionRejectionAnalysisSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.admissionrejectionanalysissearchform',
    //frame: true,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        itemId: 'admissionRejectionAnalysisProgrmBatchSeatTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype : 'customcombobox',
        	fieldLabel : getCommonTranslation('INTAKE_YEAR'),
        	name : 'intakeYear',
        	itemId : 'intakeYear',
        	displayField:'value',
        	valueField:'id',
//      	width:226,
        	typeAhead:true,
        	forceSelection:true,
        	minChars:3,
        	store:Ext.create('Academia.store.common.IntakeYearStore'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code}'  +
        			'</div>';
        		}
        	},
      /*  	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.IntakeYearStore');
        			combo.bindStore(store)
        		}
        	}*/
        },{
        	xtype: 'customcombobox',
	    	 name: 'programId',
	         itemId: 'programId',
	         fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	         valueField: 'id',                
	         displayField: 'valueCode',
				forceSelection:true,
				queryParam:'qry',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store:Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId'),
		/*		listeners: {
	                render: function(combo) {
	                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
	                    combo.bindStore(store);
	                }
	            },*/  
				listConfig: {   
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            getInnerTpl: function() {
                return '<div class="search-item">' +
                '{code} / {value}'+
                '</div>';
            }
        }
						
		              
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchId',
            fieldLabel: getCommonTranslation('BATCH'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            store:Ext.create('Academia.store.common.BatchesByProgramId')
         /*   listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }*/
        }]
    },{
        xtype: 'fieldcontainer',
        itemId: 'admissionRejectionAnalysisQuotaTypeQuotaContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
        	fieldLabel: getCommonTranslation('SEAT_TYPE'),
        	editable: false,
        	name: 'seatTypeId',
        	itemId: 'seatTypeId',
        	valueField: 'seatTypeId',                
        	displayField: 'seatTypeName',
        	queryMode: 'local',
        	listeners: {
        		render: function(combo) {
        			var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
        			combo.bindStore(store);
        		}
        	}
        },{
            xtype: 'customcombobox',
            name: 'quotaTypeId',
            itemId: 'quotaTypeId',
            fieldLabel: getAdmissionTranslation('QUOTA_TYPE'),
            displayField: 'code',
            valueField: 'id',
            queryMode: 'remote',
            store:Ext.create('Academia.store.admission.selectionProcess.QuotaTypes'),
       /*     listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.selectionProcess.QuotaTypes');
                    combo.bindStore(store);
                }
            }*/
        }, {
            xtype: 'customcombobox',
            name: 'quotaId',
            itemId: 'quotaId',
            fieldLabel: getAdmissionTranslation('QUOTA'),
            displayField: 'code',
            valueField: 'id',
            queryMode: 'local',
            store:Ext.create('Academia.store.admission.quotas.QuotaLists'),
        /*  listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.quotas.QuotaLists');
                    combo.bindStore(store);
                }
            }*/
        }]
    },{
        xtype: 'fieldcontainer',
        itemId: 'admissionRejectionAnalysisAcademyStartDateEndDateContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
                xtype: 'datefield',
                fieldLabel: getAdmissionTranslation('START_DATE'),
                name: 'startDate',
                itemId :'startDate',
                vtype: 'daterange',
    			endDateField: 'endDate',
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
            },{
                xtype: 'datefield',
                fieldLabel: getAdmissionTranslation('END_DATE'),
                name: 'endDate',
                itemId: 'endDate',
                vtype: 'daterange',
    			startDateField: 'startDate',
                listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT
            }]

    },{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('CLEAR_SEARCH'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});