/*
 * @author Soham Gurjar
 */
Ext.define('Academia.view.reports.admission.dashboard.DtefCourseEnrollmentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.dtefcourseenrollmentgrid',
	store : 'reports.admission.CourseEnrollmentDtefDashboardGridStore',
	cls:'enqgridsummarycls',
	border: true,
	frame:false,
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	isGridConfigurable:  true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'reports.admission.CourseEnrollmentDtefDashboardGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);    
		this.setTitle(getCommonTranslation('DTEF_COURSE_ENROLLMENT_LIST')); 
	},
	tbar : [{
		xtype : 'button',
		itemId : 'sendToDTEFBtn',
		tooltip : getCommonTranslation('SEND_TO_DTEF'),
		text : getCommonTranslation('SEND_TO_DTEF'),
		disabled:true,

	},'->',
	],
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getAdmissionTranslation('NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getAdmissionTranslation('ACADEMY'),
		dataIndex: 'academyName',
		flex:.1
	},{
		header:   getEnquiryTranslation('LOCATION'),
		dataIndex: 'locationName',
		flex:.1
	},{
		header:  getAdmissionTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1
	},{
		header:  getAdmissionTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1
	},{
		header:  getAdmissionTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		flex:.1
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1
	},{
		header:  getCourseTxCommonTranslation('COURSE_CODE'),
		dataIndex: 'courseCodes',
		flex:.1,
		renderer:function(value){
			var count = value.length;
			if(count!=null && count >0){
			  return '<a  href="#">'+count+'</a>';
			}else{
				return 0;
			}
		}
	},{
		header:  getCommonTranslation('RESPONSE_STATUS'),
		dataIndex: 'responseStatus',
		flex:.1,
	},{
		header:  getCommonTranslation('RESPONSE'),
		dataIndex: 'response',
		flex:.1
	},{
		header:  getCommonTranslation('RESPONSE_DATE'),
		dataIndex: 'responseDate',
		flex:.1,
		renderer:function(date) {
            if(!isNullOrEmpty(date)){
             return dateRender(date);
            }else{
                return null;            
            }
            }
	}]
});