Ext.define('Academia.view.reports.allReports.ReportInnerMenuDataView', {
    extend: 'Ext.view.View',
    alias: 'widget.reportinnermenudataview',

    initComponent: function () {
        var me = this;

        me.store = Ext.create('Academia.store.reports.allReports.ReportInnerMenuDataViewStore', {
            autoLoad: false
        });

        me.callParent(arguments);
    },

    tpl: new Ext.XTemplate(
        '<div class="report-list">',
        '   <tpl for=".">',
        '       <div class="report-item { [values.highlight ? "highlight" : ""] }">',
        '           <div class="report-name">{featureName}</div>',
        '           <div class="report-count">{[this.formatCount(values.subMenuCount)]}</div>',
        '       </div>',
        '   </tpl>',
        '</div>',
        {
            formatCount: function (count) {
                return Ext.String.leftPad(count, 2, '0');
            }
        }
    ),

    itemSelector: '.report-item',  // <-- must be defined
    singleSelect: true,            // <-- enables single highlight selection
    selectedItemCls: 'report-item-selected', // <-- highlight CSS is applied here

    /*listeners: {
        itemclick: function (view, record) {
            Ext.Msg.alert('Report Selected', record.get('featureName'));
        }
    }*/
});