/**
 * This is used for stacked bar chart report
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.common.StackedBarChartReport', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.stackedbarchartreport',
    animate: true,
    shadow: true,
    legend: {
        position: 'right'
    },
    initComponent: function() {
        var this$ = this;
        var numberField = !isNullOrEmpty(this.xAxesNumericField)?this.xAxesNumericField:'number';
        var categoryField = !isNullOrEmpty(this.yAxesCategoryField)?this.yAxesCategoryField:'category';
        var numericTitle = !isNullOrEmpty(this.xAxesNumericTitle)?this.xAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.yAxesCategoryTitle)?this.yAxesCategoryTitle:getCommonTranslation('CATEGOTY_TITLE');
        var columnHeight = !isNullOrEmpty(this.columnHeight)?this.columnHeight: REPORT_CONSTANTS.COMMON_COLUMN_HEIGHT;
        var columnColor = !isNullOrEmpty(this.columnColor)?this.columnColor: REPORT_CONSTANTS.COMMON_COLOR;
        var chartStore = null;
        var storeFields = this.fields;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store,{
        		fields: storeFields
        	});
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
        	axes: [{
                type: 'Numeric',
                position: 'bottom',
                fields: categoryField,
                title: numericTitle,
                grid: true,
                minimum: 0,
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                }
            }, {
                type: 'Category',
                position: 'left',
                fields: [numberField],
                title: categoryTitle
            }],
            series: [{
                type: 'bar',
                axis: 'bottom',
                gutter: 40,
                xField: numberField,
                yField: categoryField,
                stacked: true,
                tips: {
                    trackMouse: true,
                    width: 140,
                    height: 28,
                    renderer: function(storeItem, item) {
                        this.setTitle(String(item.value[1]));
                      }
                },
	            renderer: function(sprite, storeItem, barAttr, i, store) {
	            	barAttr.height = columnHeight;
	          	  	return barAttr;
	            }
            }],
            listeners: {
                refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var gutter = 40;
                		var chartHeight = (count * columnHeight)+ (count * gutter) + 60; 
                		chart.setHeight(chartHeight);
                		chart.doComponentLayout();
                	}
                }
            }
        });

        this$.callParent(arguments);
    }
});