/**
 * This view is used for student count of request
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.complaints.PendingComplaintsHistoryView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pendingcomplaintshistoryview',
    title: getServiceRequestTranslation('GRIEVANCE_PENDING_GRAPH'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'pendingcomplaintshistorysearch',
        itemId: 'pendingComplaintsHistorySearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'pendingComplaintHistoryChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.CountOfRequestStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_GRIEVANCES'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('MONTHS')
        }]
    }]
});