/** 
 * This panel is used for completion statistics panel view
 * @author Prathamesh.Sheth
 * 
 */
Ext.define('Academia.view.reports.completion.CompletionStatisticsPanel', {
	extend : 'Ext.panel.Panel',
    alias: 'widget.completionstatisticspanel',
    autoScroll:true,
	frame:true,
	//cls: 'panelNoSpace',
	title:getCompletionModuleTranslation('COMPLETION_STATISTICS'), //'Completion Statistics'
	//border:true,
    items: [{
    	xtype:'completionsearchform',
    	itemId:'completionSearchForm'
    },{
    	xtype: 'form',
    	frame: true,    	
    	items:[{
            xtype: 'barchartreport',
            itemId: 'terminationStatisticsChart',
            minWidth: 700,                                                           
            height: 500,
            columnHeight: 70,
            columnColor: 'orange',
            store: 'Academia.store.reports.completion.TerminationStatisticsChartStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle:  getCompletionModuleTranslation('STATISTICS_COUNT'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getCompletionModuleTranslation('ACADEMIES')
        }]
    },{
    	xtype: 'form',
    	itemId:'terminationReasonChartFormPanel',
    	frame: true,    	
    	items:[{
            xtype: 'barchartreport',
            itemId: 'terminationReasonChart',
            minWidth: 700,                 
            height: 500,            
            columnHeight: 30,
            columnColor: 'orange',
            store: 'Academia.store.reports.completion.TerminationStatisticsChartStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getCompletionModuleTranslation('TERMINATION_COUNT'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getCompletionModuleTranslation('REASONS')
        }]
    }]
});