/**
 * This view is used for the Online User Report List.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.systemutilization.onlineusers.OnlineUserReportQuickSearchView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.onlineuserreportquicksearchview',
   // cls: 'horizontalScrollingFixed',
    autoScroll: true,
    cls:'horizontalScrollingFixed',
	plain: true,
    defaults:{
    	width:'100%'
    },
    layout:'vbox',
    items: [{
        xtype: 'onlineuserreportquicksearchform',
        itemId: 'onlineUserReportQuickSearch'
    }, {
        xtype: 'tabpanel',
        //minWidth: 800,
        plain: true,
        itemId:'onlineuserreporttabpanelId',
        activeTab: 0,
        items: [{
        	//xtype: 'searchresultgrid',
        	//itemId: 'onlineUserReportResultGrid',
        	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
        	items:[{
        		xtype: 'searchresultgrid',
                title: getCommonTranslation('ONLINE_USER_REPORT'),
                itemId: 'onlineUserReportResultGrid'
        	}]
        }, {
            xtype: 'panel',
            itemId: 'moduleReportpanel',
            title: getCommonTranslation('MODULE_WISE_SUMMARY'),
            width: '70%',
            items: [{
            	xtype: 'columnchartreport',
                itemId: 'onlineUserModuleWiseChart',
                width: 700,
                minHeight: 400,
                columnWidth: 50,
                columnColor: 'orange',
                store: 'Academia.store.reports.systemutilization.onlineusers.OnlineUserReportModuleWiseSummaryGraphStore',
                xAxesNumericField: 'NO_OF_USERS',
               //xAxesNumericTitle: getCommonTranslation('USER_NAME'),
                yAxesCategoryField: 'MODULE_NAME',
                yAxesCategoryTitle: getCommonTranslation('MODULE_NAME') 
            }]
        }, {
            xtype: 'panel',
            itemId: 'groupReportPanel',
            title: getCommonTranslation('GROUP_WISE_SUMMARY'),
            width: '70%',
            items: [{
                	xtype: 'columnchartreport',
                    itemId: 'onlineUserGroupWiseChart',
                    width: 700,
                    minHeight: 400,
                    columnWidth: 50,
                    columnColor: 'orange',
                    store: 'Academia.store.reports.systemutilization.onlineusers.OnlineUserReportGroupWiseSummaryStore',
                    xAxesNumericField: 'NO_OF_USERS',
//                  xAxesNumericTitle:getCommonTranslation('USER_NAME'),
                    yAxesCategoryField: 'USER_GROUP',
                    yAxesCategoryTitle: getCommonTranslation('USER_GROUP') 
                	
            }]
        }]
    }]
});