/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.scholarship.managescholarship.ManageScholarshipStudentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.managescholarshipstudentlistgrid',
	store: 'scholarships.ManageScholarshipStdListGridStore',
	title: getCommonTranslation("MANAGE_SCHOLARSHIP_STUDENT_LIST"),
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	 headerFix:{
		    headerFix: true,
		    portalIdsWithStructure: {
		    'manageScholarshipStructure':1
		    }},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarships.ManageScholarshipStdListGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		iconCls:'icon-addbutton',
		cls:'addbutton'
	},
		{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	},
	{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		iconCls: 'icon-Delete',
		cls:'iconDelete',
		disabled: true
	}],
	columns: [{
		header:  getCommonTranslation("SCHOLARSHIP_APPLICATION_ID"),
		dataIndex:'scholarshipApplicationID',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SCHOLARSHIP_ID"),
		dataIndex:'scholarshipCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SCHOLARSHIP_NAME"),
		dataIndex:'scholarshipName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("ACCOUNTING_YEAR"),
		dataIndex:'accountingYear',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("STUDENT_ID"),
		dataIndex:'studentCode',
		flex:.1,
		sortable:true,
	},{
		header:  getCommonTranslation("STUDENT_NAME"),
		dataIndex:'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("PROGRAM_NAME"),
		dataIndex:'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("BATCH"),
		dataIndex:'batch',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("AMOUNT"),
		dataIndex:'amount',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("STATUS"),
		dataIndex:'status',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!Ext.isEmpty(record.get("status"))){
				switch(record.get("status")) {
				  case 'NOMINATED':
					  return getCommonTranslation("NOMINATED");
					  break;
				  case 'ACCEPTANCE_PENDING': 
					  return getCommonTranslation("ACCEPTANCE_PENDING");
					  break;
				  case 'REJECTED':
					  return getCommonTranslation("REJECTED");
				    break;
				  case 'DECLINED':
					  return getCommonTranslation("DECLINED");
				    break;
				  case 'ACCEPTED':
					  return getCommonTranslation("ACCEPTED");
				    break;
				  case 'AWARDED':
					  return getCommonTranslation("AWARDED");
				    break;
				  case 'DOCUMENT_RE_SUBMISSION':
					  return getCommonTranslation("DOCUMENT_RE_SUBMISSION");
					    break;
				  case 'AWARD_ACTIVATION_PENDING':
					  return getCommonTranslation("AWARD_ACTIVATION_PENDING");
					    break;
				  case 'VERIFICATION_IN_PROGRESS':
					  return getCommonTranslation("VERIFICATION_IN_PROGRESS");
					  break;
				  case 'SCHOLARSHIP_ACTIVATED':
					  return getCommonTranslation("SCHOLARSHIP_ACTIVATED");
					  break;
				  case 'AWARD_ACTIVATION_REJECTED':
					  return getCommonTranslation("AWARD_ACTIVATION_REJECTED");
					  break;
				  default:
					  break;
				}
			}
	}
	}]
});