/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.AccountingDetailsSetupWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.accountingDetailsSetupWin',
	title:getFeeAndPaymentCommonTranslation('ACCOUNTING_DETAILS_SETUP'),
	frame: true,
	autoScroll:false,
	modal:true, 
    layout:'vbox',
    defaults:{
    	width:'100%'
    },
	width: '55%',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		items: [{
			xtype: 'displayfield',
			fieldLabel: getFeeAndPaymentCommonTranslation('ACCOUNTING_TYPE'),
			labelWidth: 300
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: '100%',
				labelWidth: 300
			},
			items: [{
				xtype: 'radiogroup',
				itemId: 'accountingType',
				layout: 'hbox',
				items: [{
					boxLabel: getFeeAndPaymentCommonTranslation('COST_CENTRE_BASED'),
					name: 'accountingBased',
					inputValue: 'costCenterBased',
					checked: true

				}, {
					boxLabel: getFeeAndPaymentCommonTranslation('POET_BASED'),
					name: 'accountingBased',
					margin: '0 0 0 70',
					inputValue: 'poetBased'
				},{
					boxLabel: getFeeAndPaymentCommonTranslation('DYNAMIC'),
					name: 'accountingBased',
					margin: '0 0 0 70',
					inputValue: 'dynamicBased'
				}]
			}]
		},{


			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 245
			},
			items: [{
				xtype: 'customcombobox',
				name: 'accountYearId',
				itemId: 'accountYearId',
				fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
				store: 'scholarships.AccountYearStore',
				valueField: 'id',
				displayField: 'currentAccountingYear',
				allowBlank:false,
				editable: false,
				forceSelection:true
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('TOTAL_BUDGET'),
				name: 'totalBuget',
				itemId: 'totalBuget',
				allowBlank: false,
				enforceMaxLength:true,
				decimalPrecision: 2,
				maxLength:13,
		        maxValue: 9999999999.99,
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false
			},{
				xtype: 'numberfield',
				fieldLabel: getCommonTranslation('BALANCE_AMOUNT'),
				name: 'balanceAmount',
				itemId: 'balanceAmount',
				allowBlank: false,
				readOnly:true,
				enforceMaxLength:true,
				decimalPrecision: 2,
				maxLength:13,
		        maxValue: 9999999999.99
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 245
			},
			itemId:'costCenterView',
			items: [{
				xtype: 'customcombobox',
				name: 'costCenterId',
				itemId: 'costCenterId',
				fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
				store: 'scholarships.AccountCostCenterStore',
				displayField: 'value',
				valueField: 'id',
				allowBlank:false,
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
			},{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('FEE_HEAD'),
				name: 'feeHead',
				readOnly:true,
				itemId: 'feeHead'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 245
			},
			hidden:true,
			disabled:true,
			itemId:'projectNumberId',
			items: [{
				xtype: 'customcombobox',
				name: 'projectNumber',
				itemId: 'projectNumber',
				fieldLabel: getCommonTranslation('PROJECT_NUMBER'),
				store: 'scholarships.AccountProjectNumber',
				displayField: 'valueCode',
				valueField: 'id',
				allowBlank:false,
				allowBlank:false,
				queryParam:'qry',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			},{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('FEE_HEAD'),
				name: 'feeHeadProject',
				readOnly:true,
				itemId: 'feeHeadProject'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 245
			},
			hidden:true,
			disabled:true,
			itemId:'taskNumberId',
			items: [{
				xtype: 'customcombobox',
				name: 'taskNumber',
				itemId: 'taskNumber',
				fieldLabel: getCommonTranslation('TASK_NUMBER'),
				store: 'scholarships.TaskNumberStore',
				displayField: 'valueCode',
				valueField: 'id',
				allowBlank:false,
				allowBlank:false,
				disabled:true,
				queryParam:'query',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			},{
				xtype: 'customcombobox',
				name: 'contractNumber',
				itemId: 'contractNumber',
				fieldLabel: getCommonTranslation('CONTRACT_NUMBER'),
				store: 'scholarships.ContractNumberStore',
				displayField: 'valueCode',
				valueField: 'id',
				disabled:true,
				queryParam:'query',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
			},{
				xtype: 'customcombobox',
				name: 'fundingSourceNumber',
				itemId: 'fundingSourceNumber',
				fieldLabel: getCommonTranslation('FUNDING_SOURCE_NUMBER'),
				store: 'scholarships.FundingSourceNumberStore',
				displayField: 'valueCode',
				valueField: 'id',
				disabled:true,
				queryParam:'query',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 245
			},
			hidden:true,
			disabled:true,
			itemId:'expenditureTypeId',
			items: [{
				xtype: 'customcombobox',
				name: 'expenditureType',
				itemId: 'expenditureType',
				fieldLabel: getCommonTranslation('EXPENDITURE_TYPE'),
				store: 'scholarships.ExpenditureTypeStore',
				displayField: 'value',
				valueField: 'id',
				allowBlank:false,
				allowBlank:false,
				queryParam:'query',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
			},{
				xtype: 'customcombobox',
				name: 'expenditureOrg',
				itemId: 'expenditureOrg',
				fieldLabel: getCommonTranslation('EXPENDITURE_ORGANIZATION'),
				store: 'scholarships.ExpenditureOrganizationStore',
				displayField: 'value',
				valueField: 'id',
				allowBlank:false,
				allowBlank:false,
				queryParam:'query',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 245
			},
			items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('AWARD_WITH_OTHER'),
                name: 'awardWithOther',
                itemId: 'awardWithOther',
                store: Ext.create('Ext.data.Store', {
                    fields: ['value', 'name'],
                    data: [{
                		id:'YES',
                		value:getCommonTranslation('YES') 
                	},{
                		id:'NO',
                		value:getCommonTranslation('NO') 
                	},{
                		id:'ONLY_ALLOWED_SCHOLARSHIP',
                		value:getCommonTranslation('ONLY_ALLOWED_SCHOLARSHIP') 
                	}]
                }),
                displayField: 'value',
                valueField: 'id',
                queryMode: 'local',
                editable: false,
                forceSelection: true
            },{
            	xtype: 'multiselectcombofield',
				name: 'allowedScholarship',
				itemId: 'allowedScholarship',
				fieldLabel:getCommonTranslation('ALLOWED_SCHOLARSHIP_ID/NAME'),
				store:Ext.create('Academia.store.scholarships.allowSchoalrshipIDNameStore'),
				queryParam: "qry",
				displayField: 'valueCode',
                valueField: 'id',
                hidden:true,
				forceSelection : true,
				allowBlank:false,
				disabled:true,
				cls:'commonAutoHeightMultiselectField',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,			
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')	,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code} / {value}' +
    					'</div>';
    				}
    			}
            }]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			cls: 'windowBtnPos',
			style: {
				marginTop: '17px',
				marginLeft: '-2px'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'accountDetailBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				buttonAlign: 'right',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]     
});