/**
 * @author pritam.patil
 * 
 * This component is used for to show number of awardee details in grid 
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.NumberOfAwardeeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.numberofawardeegrid',
	store: 'scholarships.awardees',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS		
	},		  
	border: true,	
	//autoScroll:true,
	columns :[{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',		
		flex:.2,
		renderer: function(value) {
        	if(!isNullOrEmpty(value))
            	   value="<a href='#'>"+value+"</a>";
            return value;
        }
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',		
		flex:.2
	}],
	tbar: [{
        xtype: 'customcombobox',
        itemId: 'statusComboId',
        fieldLabel: getCommonTranslation('STATUS'),
        editable: false,
        store: 'scholarships.ViewAwardeeStatusComboStore',
        displayField: 'value',
        valueField: 'id',
        selectOnFocus:true,
        loading : true,
        //queryMode:'local'
        value : 'CURRENT'
        
    }], 
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'scholarships.awardees',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }]
});