/**
 *
 * This component is used  to show Period Grid
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.PeriodsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.periodsgrid',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAddPeriod',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
        
    }, {
        xtype: 'button',
        itemId: 'btnEditPeriod',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
       
    }, {
        xtype: 'button',
        itemId: 'btnViewPeriod',
        tooltip:getCommonTranslation('VIEW'), 
        iconCls: 'view-icon'
       
    }, {
        xtype: 'button',
        itemId: 'btnDeletePeriod',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
       
    }],
    /*selModel:Ext.create('Ext.selection.CheckboxModel',{
    	singleSelect: true,
    	showHeaderCheckbox : false,
    	itemId : 'selModelId'
    }),*/
    columns: [/*{
        dataIndex: 'id',
        hidden: true
    },*/
    {
        header: getUserModuleTranslation('PERIOD_SEQUENCE'),
        dataIndex: 'periodSequence',
        align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getUserModuleTranslation('PERIOD_NAME'),
        dataIndex: 'periodName',
        align: 'center',
        sortable: true,
        flex: .4
    }, {
        header: getUserModuleTranslation('DURATION'),
        dataIndex: 'durationInMonth',
        align: 'center',
        sortable: true,
        flex: .4
    }, {
        header: getUserModuleTranslation('AMOUNT'),
        dataIndex: 'amount',
        align: 'center',
        sortable: true,
        flex: .2

    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store/*,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]*/
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.scholarships.Periods');
    }
});