/**
 * Screen which contains the Search filters of the Scholarship MAster.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.ScholarshipMasterSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.scholarshipmastersearchform',
    autoScroll: true,
    frame: true,
    cls: 'customSearchPanel',
    layout: 'vbox',
    frame: false,
    height: '30%',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        cls: 'customSearchPanel',
        itemId: 'scholarshipMaster',
        layout: 'vbox',        
        items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [
            {
            	xtype: 'multiselectcombofield',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				allowBlank: false,
				name: 'ACADEMY_LOCATION',
				itemId:'academyLocationCombo',
				store: 'scholarships.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id',
				width:460,
				queryParam:'nameOrCode',
				minChars:3,
				triggerAction: 'all',
    			forceSelection:true,
    			typeAhead:true,
			}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
                itemId: 'scholMaster_scholId',
                name: 'SCHOLARSHIP_ID',
                enableKeyEvents: true,
                vtype: 'NospaceAsInput',
                store:'feeandpayment.managebill.ScholarshipSmartSearch',
                //store: Ext.create('Academia.store.scholarships.allowSchoalrshipIDNameStore'),
    			valueField: 'id',
    			displayField: 'scholarshipNameValue',
    			queryParam:'scholarshipNameOrCode',
    			minChars:3,
    			typeAhead:false,
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			triggerAction: '',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
    				},
            {
               xtype: 'customcombobox',
                fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP_CATEGORY'),
                name: 'SCHOLARSHIP_CATEGORY',
                itemId: 'scholarship_category',
                editable: false,
                store: Ext.create('Academia.store.scholarships.ScholarshipCategoryStores'),
                displayField: 'value',
                valueField: 'id',
                typeAhead:true,
                forceSelection:true,
            },
            ]
			}, {

				xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				itemId: 'Statuspanel',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('AMOUNT_TYPE'),
					name: 'AMOUNT_TYPE',
					itemId: 'scholMaster_amountType',
					editable: false,
					store: 'scholarships.AmountTypes',
					displayField: 'value',
					valueField: 'id',
					selectOnFocus: true,
					forceSelection: false
				},
				{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('STATUS'),
					name: 'SCHOLARSHIP_STATUS',
					itemId: 'scholMaster_status',
					editable: false,
					store: 'scholarships.Status',
					displayField: 'Status',
					selectOnFocus: true,
					value: getCommonTranslation('ACTIVE'),
					forceSelection: false,
					allowBlank: false
				}
				]
			}, {
				xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				itemId: 'schWithoutMappingPanel',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [
					{

						xtype: 'checkboxfield',
						width: 'auto',
						width: 226,
						style: {
							//marginTop: '25px'
						},
						//labelAlign: 'right',
						itemId: 'schWithoutMappingId',
						boxLabel: getCommonTranslation('SCHOLARSHIP_WITHOUT_MAPPING'),
						name: 'SCHOLARSHIP_WITHOUT_MAPPING',
						inputValue: true

					}
				]
			}, {
				xtype: 'fieldcontainer',
				width: 'auto',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'ScholarshipMasterSearchBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind: true
				}, {
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'ScholarshipMasterResetBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					listeners: {
						click: function(button, eOpts) {
							//this.up('form').getForm().reset();
						}
					}
				}]
			}]
	}]
});