Ext.define('Academia.view.securitysetup.ProgramCourseTreeForUser',{
	 extend: 'Ext.tree.Panel',
	  		alias:'widget.programusertree',
		     width: 500,
		    height: 350,
		    frame:true,
		     store: 'securitysetup.ProgramsForUsers',
		     rootVisible: true,
		     singleExpand: true,
		     plugins: [{
		        ptype: 'treefilter',
		         allowParentFolders: true
		    }],
		     dockedItems: [{
		        xtype: 'toolbar',
		         dock: 'top',
		         items: [{
		            xtype: 'trigger',
		             triggerCls: 'x-form-clear-trigger',
		             onTriggerClick: function () {
		                this.reset();
		                this.focus();
		            }, 	
		             listeners: {
		                change: function (field, newVal) {
		                    var tree = field.up('treepanel');
		                    tree.filter(newVal);
		                },
		                 buffer: 250
		            }
		        }]
		    }],
		    listeners: {
		    	checkchange: function (node, isChecked) {
		    		// Propagate change downwards (for all children of current node).
		    	    var setChildrenCheckedStatus = function (current) {
		    	        if (current.parentNode) {
		    	            var parent = current.parentNode;
		    	            current.set('checked', parent.get('checked'));
		    	        }

		    	        if (current.hasChildNodes()) {
		    	            current.eachChild(arguments.callee);
		    	        }
		    	    };
		    	    if (node.hasChildNodes()) {
		    	        node.eachChild(setChildrenCheckedStatus);
		    	    }

		    	    // Propagate change upwards (if all siblings are the same, update parent).
		    	    var updateParentCheckedStatus = function (current) {
		    	        if (current.parentNode && !current.parentNode.isRoot()) {
		    	            var parent = current.parentNode;

		    	            var checkedCount = 0;
		    	            parent.eachChild(function(n) {
		    	                checkedCount += (n.get('checked') ? 1 : 0);
		    	            });

		    	            
		    	            if (checkedCount > 0) {		    	               
		    	                parent.set('checked', true);
		    	            } else {
		    	                // Not all of the children are checked, so uncheck the parent.
		    	                parent.set('checked', false);
		    	            }

		    	            updateParentCheckedStatus(parent);
		    	        }
		    	    }
		    	    updateParentCheckedStatus(node);
                }
            }
});