/**
 * @author pritam.patil
 * fee Details Grid 
 */
Ext.define('Academia.view.servicerequest.common.FeeDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.feedetailsgrid',
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getServiceRequestTranslation('BILL'),
        dataIndex: 'bill',
        sortable: true,
        flex: .2
    },{
        header: getServiceRequestTranslation('BILL_TYPE'),
        dataIndex: 'billType',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('FEE_PLAN'),
        dataIndex: 'feePlan',
        sortable: true,
        flex: .2
    },  {
        header: getServiceRequestTranslation('FEE_HEAD'),
        dataIndex: 'feeHead',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('FEE_AMOUNT'),
        dataIndex: 'feeAmount',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('DISCOUNT'),
        dataIndex: 'discount',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('AMOUNT_PAID'),
        dataIndex: 'amountPaid',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('AMOUNT_PENDING'),
        dataIndex: 'amountPending',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('BILLING_DATE'),
        dataIndex: 'billingDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getServiceRequestTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getServiceRequestTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.completion.completionform.PendingPaymentGrids');
    }

});