/**
 * @author pritam.patil
 * refund Details Grid 
 */
Ext.define('Academia.view.servicerequest.common.RefundDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.refunddetailsgrid',
    store:Ext.create('Academia.store.servicerequest.common.RefundDetailsGridStore'),
    title:getServiceRequestTranslation('REFUND_DETAILS'),
    border: true,
    collapsible :true,
    viewConfig: {
        stripeRows: true
    },
    columns:[{
		header:getServiceRequestTranslation('BILL_NO'),
		dataIndex:'billNo',
		flex:0.1
	},{
		header:getServiceRequestTranslation('BILL_TYPE'),
		dataIndex:'raiseBillType',
		flex:0.1
	},{
		header:getServiceRequestTranslation('FEE_HEAD'),
		dataIndex:'feeHeadName',
		flex:0.1
	},{
		header:getServiceRequestTranslation('FEE_AMOUNT'),
		dataIndex:'feeAmount',
		flex:0.1
	},{
		header:getServiceRequestTranslation('DISCOUNT'),
		dataIndex:'discountAmount',
		flex:0.1
	},{
		header:getServiceRequestTranslation('AMOUNT_PAID'),
		dataIndex:'amountPaid',
		flex:0.1
	},{
		header:getServiceRequestTranslation('AMOUNT_PENDING'),
		dataIndex:'amountPending',
		flex:0.1
	},{
		header:getServiceRequestTranslation('BILL_DATE'),
		dataIndex:'billingDate',
		flex:0.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:getServiceRequestTranslation('DUE_DATE'),
		dataIndex:'dueDate',
		flex:0.1,
		renderer:function(date) {
			return dateRender(date);
		}	
	}]

});