Ext.define('Academia.view.servicerequest.documents.ServiceRequestMandatoryDocumentGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.servicerequestmandatorydocuments',
	//store:'servicerequest.common.ServiceRequestDocuments',
	title:getServiceRequestTranslation('MANDATORY_DOCUMENTS'),
	border:true,
	enableColumnHide: false,
	style: {
		'position': 'relative !important'
	},
	cls:'centerAlignTitle',
	columns:[{
		header:getServiceRequestTranslation('DOCUMENT_NAME'),
		dataIndex:'documentType',
		renderer:function(obj) {
			return  '<a href="#">'+obj.value+'</a>';
		},
		flex:1,
        sortable: false
	},{
		//header:getServiceRequestTranslation('DOCUMENT_NAME'),
		dataIndex:'document',
		renderer:function(obj,meta,record) {
			if(!isNullOrEmpty(record.data.documentRule) && !isNullOrEmpty(record.data.documentRule.document)){
				return '<a href=#>'+record.data.documentRule.document.name+'</a>';
			}
		},
		flex:0.5,
        sortable: false
	}],
	tbar:[{
        xtype: 'button',
        itemId: 'btnUploadDocument',
        tooltip : getCommonTranslation('UPLOAD'),
        text:getCommonTranslation('UPLOAD')
    }, {
    	xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip : getCommonTranslation('DELETE'),   
        text:getCommonTranslation('DELETE')
    },{
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip : getCommonTranslation('EDIT'),
        text:getCommonTranslation('EDIT'),
        hidden : true
    }, {
        xtype: 'button',
        itemId: 'btnDownloadDocument',
        tooltip : getServiceRequestTranslation('DOWNLOAD'),
        text : getServiceRequestTranslation('DOWNLOAD'), 
        hidden : true
    }],
	initComponent: function() {
	    var this$ = this;
	    var store = this$.buildStore();
	    Ext.apply(this$, {
	        store: store
	    });
	
	    this$.callParent(arguments);
	},
	buildStore: function() {
	    return Ext.create('Academia.store.servicerequest.common.ServiceRequestDocuments');
	}
}); 