/**
 * Dharmendra.p 
 */
Ext.define('Academia.view.servicerequest.eventcalendar.EventCalendarWin',{
	extend: 'Ext.window.Window',
	alias : 'widget.eventcalendarwin',
	title : getCommonTranslation('TS_EVENT_CALENDAR'),
	frame: true,
	resizable:true,
	autoScroll: true,
	modal:true, 
	method: 'POST',
	height: '75%',
	width: '45%',
	items : [{
		xtype: 'form',
		standardSubmit : false,
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top'
		},
		items: [{
		xtype:'hidden',
		name:'id',
		itemId:'id'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'name',
			fieldLabel : getServiceRequestTranslation('CALENDAR_NAME'),
 			allowBlank : false,
 			width : 460,
 			maxLength: 150
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getServiceRequestTranslation('VALID_FROM'),
			name : 'validFrom',
			itemId:'validFrom',	
			endDateField : 'validTo',
			allowBlank : false,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		},{
			xtype : 'datefield',
			fieldLabel : getServiceRequestTranslation('VALID_TO'),
			name : 'validTo',
			itemId:'validTo',
			startDateField : 'validFrom',
			allowBlank : false,
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : 'hbox',
		fieldLabel : getServiceRequestTranslation('DISPLAY_TO'),
		defaults : {
			width : 226,
//			labelAlign : 'top'
		},
		items : [{
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			boxLabel: getServiceRequestTranslation('STUDENTS'),
			name: 'displayToStudent',
			inputValue : true,
			uncheckedValue:false 
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			boxLabel: getServiceRequestTranslation('EMPLOYEE'),
			name: 'displayToEmployee',
			inputValue : true,
			uncheckedValue: false
		}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : 'vbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'textarea',
				name: 'description',
				fieldLabel: getServiceRequestTranslation('DESCRIPTION'),
				width:460
			},{
	            xtype: 'customcombobox',
	            fieldLabel: getServiceRequestTranslation('STATUS'),
	            store : 'common.StatusComboStore',
	            editable : false,
	            value:'ACTIVE',
	            name: 'status',
	            valueField: 'id',
	            displayField: 'name'
	        }]
			},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'saveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});