Ext.define('Academia.view.servicerequest.feeservicerequest.ReAddmissionServiceRequestWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.reAddmissionServiceRequestWin',
    title: getServiceRequestTranslation('APPLICATION_READMISSION_STUDENT_STRICTLY_CONFIDENTIAL'),
    frame: true,
    modal: true,
    autoScroll: false,
    cls: 'columnWindowClsReaddmission horizontalScrollingFixed',
    width: '80%',
    height: '80%',
    layout: 'fit',
    closable: false,
    items: [{
        xtype: 'form',
        autoScroll: true,
        plugins: "formlabelrequired",
        itemId: 'reAddmissionFormView',
        layout: 'vbox',
        width: '90%',
        defaults: {
            width: '98%'
        },
        items: [{
            xtype: 'fieldset',
            style: {
                'margin-top': '-10px !important',
                'padding-top': '0px !important'
            },
            items: [{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                margin: '10 0 0 0',
                items: [{
                xtype: 'label',
                flex: 2,
                cls: 'htmlClsLabel',
                text: getServiceRequestTranslation('PLEASE_COMPLETE_RELEVANT_SECTIONS_APPLICATION')
                },{
                	 flex: 1,
                     cls: 'htmlClsLabel',
                     html: '<div style="background-color: #f6f6f6;font-size: 16px;padding: 5px;border-radius: 4px;"><img src="resources/images/info.svg" width="20" height="20" style="margin-right: 10px;margin-left: 5px;transform: translate(0px, 5px);"/><span style="font-size: 14px;">'+getServiceRequestTranslation('FILE_SUPPORTED')+'</span></div>',
                }]
            }, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                margin: '-40 0 0 0',
                items: [{
                    xtype: 'checkboxfield',
                    width: 'auto',
                    labelAlign: 'right',
                    style: { 'margin-top': '27px' },
                    name:'planningToChangeProgram',
                    itemId: 'planningToChangeProgram',
                    boxLabel: getServiceRequestTranslation('ARE_YOU_PLANNING__PROGRAMS'),
                }, {
                    xtype: 'filefield',
                    ui: 'CustomBtnCancel',
                    fieldLabel: getServiceRequestTranslation('UPLOAD_PROGRAM_CHANGE_MOTIVATION'),
                    buttonText: getCommonTranslation('BROWSE'),
                    itemId: 'uploadProgramFile',
                    name: 'uploadProgramFile',
                    validateOnChange: true,
                    allowBlank:false,
                    hidden:true,
                    disabled:true,
                    labelAlign: 'top'
                },{
        			xtype: 'button',
        			itemId: 'resetFileField',
        			cls: 'CustomToolbarBtnReject',
        			iconCls: 'icon-Delete',
        			cls:'iconDelete',
        			disabled:true,
        			hidden:true,
        			margin:'30 0 0 70'
        		}, { cls: 'htmlClsLabel',
                	itemId:'programChangeMotivation',
                	minHeight:20,
                	 hidden:true,
                	 style:{
                     	'margin':'0 !important'
                     },
                    html: '',
                    	width:'50%',
                    	margin:'35 0 0 10'
                    
                }]
            }, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                margin: '10 0 10 0',
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getServiceRequestTranslation('INTENDED_FACULTY_STUDY'),
                    name: 'intendedStudy',
                    itemId: 'intendedStudy',
                    store: 'servicerequest.feerequest.IntendedFacultyStudyStore',
                    valueField: 'id',
                    displayField: 'value',
                    allowBlank: false,
                    labelAlign: 'top',
                    width: 280,
                    queryParam: 'name',
                    enableKeyEvents: true,
                    matchFieldWidth :true,
                    minChars: 3,
                    typeAhead: false,
                    hideTrigger: false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function (picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function () {
                            return '<div class="search-item">' +
                                '{studentCode} / {studentName}' +
                                '</div>';
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getServiceRequestTranslation('INTENDED_PROGRAM_OF_STUDY'),
                    name: 'intendedProgram',
                    itemId: 'intendedProgram',
                    store: 'servicerequest.feerequest.IntendedProgramStudyStore',
                    valueField: 'id',
                    displayField: 'valueCode',
                    disabled: true,
                    allowBlank: false,
                    matchFieldWidth :true,
                    labelAlign: 'top',
                    width: 280,
                    queryParam: 'programName',
                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                    enableKeyEvents: true,
                    minChars: 3,
                    typeAhead: false,
                    hideTrigger: false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    triggerAction: '',
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function (picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function () {
                            return '<div class="search-item">' +
                                '{valueCode}' +
                                '</div>';
                        }
                    }
                }]
            }, {
                margin: '20 0 10 0',
                cls: 'htmlClsLabel',
                html: getServiceRequestTranslation('PLEASE_READ_TERMS_GUIDELINES').replace('<a>','<a href="resources/images/uploads/Readmission_Instructions.pdf" download>')
            }]
        }, {
            margin: '40 0 10 5',
            xtype: 'selectReasonReAddmissionForm',
            width: '97%'
        }, {
            xtype: 'reAddmissionFileUploadForm',
            cls: 'boxShadowReaddmission',
            width: '97%',
            margin: '0 0 0 5'
        }, {
            xtype: 'fieldcontainer',
            layout:'hbox',
            items: [{
            	xtype: 'filefield',
                ui: 'CustomBtnCancel',
                margin: '6 10 0 5',
                fieldLabel: getServiceRequestTranslation('UPLOAD_PROOF_PAYMENT'),
                buttonText: getCommonTranslation('BROWSE'),
                itemId: 'proofOfPaymnet',
                name: 'proofOfPaymnet',
                validateOnChange: true,
                width: '50%',
                labelAlign: 'top'
                
            },{
    			xtype: 'button',
    			itemId: 'resetFileField',
    			cls: 'CustomToolbarBtnReject',
    			iconCls: 'icon-Delete',
    			cls:'iconDelete',
    			disabled:true,
    			margin:'35 0 0 0'
    		}, { cls: 'htmlClsLabel',
            	itemId:'uploadProofOfPayament',
            	minHeight:20,
            	 style:{
                 	'margin':'0 !important'
                 },
                html: '',
                margin:'35 0 0 10',
                width:'50%'
            }]
        },{
            xtype: 'declarationReAddmissionForm',
            width: '98%'
        }]
    }],
    buttons: [{
        xtype: 'toolbar',
        dock: 'bottom',
        ui: 'footer',
        style:{
        	border:'none !important',
        	 margin:'0px 0px 0px 0px',
        },
       
        items:[{
        xtype: 'button',
        text: getCommonTranslation('SAVE'),
        itemId: 'readdmissionSaveBtn',
        buttonAlign: 'left',
        ui: 'CustomBtnSubmit',
        scale: CONSTANTS.BUTTONSIZE,
       // formBind: true, // Bind to the form validity
        //disabled:true,
        margin:'0 30 0 0'
    }, {
        xtype: 'button',
        itemId: 'readdmissionCancelbtn',
        text: getCommonTranslation('CANCEL'),
        ui: 'CustomBtnCancel',
        cls: 'readdmissionCancelCls',
        scale: CONSTANTS.BUTTONSIZE,
        margin:'0 0 0 0'
    }]
    }],
    buttonAlign: 'left'
    
});
