/**
 * @author Ravi.patidar
 */
Ext.define('Academia.view.servicerequest.infirmary.InfirmaryAddEntryGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.infirmaryaddentrygrid',
    //store: 'servicerequest.infirmary.InfirmaryAddEntryStore',
    title: getServiceRequestTranslation('ENTRY_TABLE'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        markDirty:false
    },
    columns: [{
        header: getServiceRequestTranslation('EMM_SERIAL_NO'),
        dataIndex: 'serialNo',
        flex: 0.1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex: 0.7,
        sortable: true,
        editor: {        	
        	xtype: 'textareafield',
            name: 'description',
            itemId: 'descriptionId',
            maxLength: 2000,
            autoScroll: true,
            grow: true,
            minHeight: 40,
            shrinkWrap: true,
            padding: 0,
            rows: 10,
            autoHeight: true,
            height: 30,
            margin: '10 0 0 0',
            listeners: {
                focus: function(th, e, oldValue, eOpts) {
                    th.autoSize();
                    var carLngth = th.getValue().length;
                    var textareaheight = 40;
                    if(carLngth>220)
                    	textareaheight = 66;
                    else if(carLngth>120 && carLngth<220)
                    	textareaheight = 52;
                    th.setHeight(textareaheight);
                    var relatedTarget = Ext.get(e.relatedTarget);
                    var currentTarget = Ext.get(e.target);
                    topValue = relatedTarget.getRegion().top;
                    currentTarget.setRegion({
                        top: topValue
                    });
//                    th.up('infirmaryaddentrygrid').doComponentLayout();
                }
            }
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.designation)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getCommonTranslation('MEDICINE_NAME'),
        dataIndex: 'medicineName',
        flex: 0.3,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'medicineId',
            itemId: 'medicineId',
            editable:false,
            displayField: 'value',
			valueField: 'id',
            maxLength: 40,
            store: 'servicerequest.infirmary.MedicineDetailCombo',
            listeners:{
            	change:function(combo,eOpt){
            		//combo.setRawValue(getCommonTranslation(combo.getValue()));
            	}
            }
        },
        renderer: function(val, rec) {
            try {
				if (isNullOrEmpty(val)) {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				} else {
					if (!isNullOrEmpty(val)) {
						var medicineStore = Academia.app.getStore('servicerequest.infirmary.MedicineDetailCombo');
						var indx = medicineStore.find('id', val);
						if (indx != -1) {
							var medicineComboRec = medicineStore.getAt(indx);
							rec.record.set('medicineId', val)
							var medicineName = medicineComboRec.get('value');
							return medicineName;
						} else {
							return val;
						}
					} else {
						return val;
					}
				}
			} catch (e) {
				// TODO: handle exception
				console.log(e);
			}
        }
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.09,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(value, meta, record) {
            if (record.data.addButton)
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.09,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (rowIndex > 0 && record.data.deleteButton) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
      }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.servicerequest.infirmary.InfirmaryAddEntryStore');
    },
  plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
            	if (editor.record.data.isEditable) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});
