Ext.define('Academia.view.servicerequest.servicerequestsettings.AssigneeApproverEditableGridForHostel',{
	extend:'Ext.grid.Panel',
	alias:'widget.assigneeapprovereditablegridforhostel',
	border:true,
	store:'servicerequest.servicerequestsettings.AssigneeApproverHostelGridStore',
	requires: [
	            'Ext.selection.CellModel',
	            'Ext.grid.*'
	        ],
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		deferEmptyText: false
	},
	plugins: [
		Ext.create('Ext.grid.plugin.CellEditing', {
			clicksToEdit: 1
		})
	],
	selModel: Ext.create('selection.cellmodel', {
		onEditorTab: function(ep, e) {
			return false;
		}
	}),
	columns:[{
		dataIndex:'id',
		hidden:true,
		sortable:false,
		menuDisabled: true
	},{
		header: getHostelTranslation('HOSTEL_NAME'),
		dataIndex:'value',
		renderer:function(value){
			return value;
		},
		flex:0.2,
		sortable:false,
		menuDisabled: true
	},{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'assigneeId',
        flex:0.2,
        sortable: false,
        menuDisabled: true,
        editor: {
            xtype: 'customcombobox',
            name: 'defaultAssignee',
            itemId: 'defaultAssignee',
            //store: 'eventmeetingminutes.EventMeetingMinutesParticipantStore',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchNameForHostel'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            onTriggerClick: function () {
                return false;
            },
            //allowBlank:false,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {                    
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{valueCode}' +
                        '</div>';
                }
            },
            listeners:{
            	keyup: function(combo,e,eOpts){
            		var comboVal = combo.getValue();
            		
            		if(!isNullOrEmpty(comboVal) && comboVal.length>2){
            			var grid = combo.up('assigneeapprovereditablegridforhostel');
                       	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                       	
                       	if(!isNullOrEmpty(selectedRecord.data.id)){
                       		var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	
                       	}
                       	var id = recordToBeUpdated.data.id;
                		var store = combo.getStore();
                		store.getProxy().extraParams = {
							id:id
						};
                		/*store.on('beforeload', function(){
    				    	
                		});*/
                		store.on('load', function(store, records, success){
                			combo.lastQuery=null;
                			delete store.getProxy().extraParams.id;
                		});
            		}
            	},
            /*	select:function(combo,records,eOpts){
            		var store = combo.getStore();
            		delete store.getProxy().extraParams.id;
            		store.load();
            	},
            	blur:function(combo,e,eOpts){
            		var store = combo.getStore();
            		delete store.getProxy().extraParams.id;
            		store.load();
            	}
*/            }
            
        },
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						delete rec.column.getEditor().store.getProxy().extraParams.id;
						//rec.column.getEditor().store.load();
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
						rec.column.getEditor().reset();
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			} else {
				if(Ext.isDefined(record.get('assigneeId')) && isNullOrEmpty(record.get('assigneeId'))){
					rec.tdCls = 'gridInputCustomStyle';
					rec.column.getEditor().reset();
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					var grid = view.up();
					var hostelList =  grid.config.hostelList;
					if(!isNullOrEmpty(hostelList) && hostelList.length>0){
						var recId = record.get('id');
						var editor = rec.column.getEditor();
						var models = grid.getStore().getRange();
						/*editor.store.getProxy().extraParams = {
							id:recId
						};*/
						delete editor.store.getProxy().extraParams.id;
						editor.store.load({
							callback:function(){
								hostelList.forEach(function(obj){
									var pgId = obj.hostel.id;
									var programId = obj.id;
									if(pgId == recId){
										if(!isNullOrEmpty(obj.defaultAssignee)){
											models[rowIndex].set("assigneeId", obj.defaultAssignee.id);
											models[rowIndex].set("hostelId", pgId);
											editor.setValue(obj.defaultAssignee.id);
										}
									}
									else{
										var assigneeId = models[rowIndex].data.assigneeId;
										if(isNullOrEmpty(assigneeId)){
											models[rowIndex].set("assigneeId", null);
											rec.tdCls = 'gridInputCustomStyle';
							                return getExaminationTranslation('CLICK_TO_ENTER');
										}
									}
								});
							}
						});
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
						rec.column.getEditor().reset();
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
			}						
		}
    },{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'defaultAssigneeAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('assigneeId',null);
        	return getServiceRequestTranslation('STUDENTS_ASSIGNEE');
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    },{
		header : getServiceRequestTranslation('DEFAULT_APPROVER'),
        dataIndex: 'approverId',
        flex:0.2,
        sortable: false,
        menuDisabled: true,
        editor: {
            xtype: 'customcombobox',
            name: 'defaultApprover',
            itemId: 'defaultApprover',
            store: Ext.create('Academia.store.servicerequest.servicerequestsettings.QuickSearchNameApproverForHostel'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            onTriggerClick: function () {
                return false;
            },
            //allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                    	/*var combo=picker.up('combo');
                    	var grid = combo.up('assigneeapprovereditablegridforhostel');
                       	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                       	
                       	if(!isNullOrEmpty(selectedRecord.data.id)){
                       		var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

                       		var id = recordToBeUpdated.data.id;
                       		combo.config.hostelId = id;
                       	}*/
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{valueCode}' +
                        '</div>';
                }
            },
            listeners:{
            	keyup: function(combo,e,eOpts){
            		var comboVal = combo.getValue();
            		
            		if(!isNullOrEmpty(comboVal) && comboVal.length>2){
            			var grid = combo.up('assigneeapprovereditablegridforhostel');
                       	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                       	
                       	if(!isNullOrEmpty(selectedRecord.data.id)){
                       		var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	
                       	}
                       	var id = recordToBeUpdated.data.id;
                		var store = combo.getStore();
                		store.getProxy().extraParams = {
							id:id
						};
                		/*store.on('beforeload', function(){
    				    	
                		});*/
                		store.on('load', function(store, records, success){
                			combo.lastQuery=null;
                			delete store.getProxy().extraParams.id;
                		});
            		}
            	},
            	select:function(combo,records,eOpts){
            		var store = combo.getStore();
            		delete store.getProxy().extraParams.id;
            		store.load();
            	},
            	blur:function(combo,e,eOpts){
            		var store = combo.getStore();
            		delete store.getProxy().extraParams.id;
            		store.load();
            	},
            	focus:function(combo,e,eOpts){
            		var originalVal = combo.getValue();
            		var store = combo.getStore();
            		var gridSelection = combo.up('grid').getSelectionModel().getSelection();
            		if(gridSelection.length>0 && isNullOrEmpty(originalVal)){
            			var id = gridSelection[0].data.id;
            			store.getProxy().extraParams = {
							id:id
						};
            			store.load({
            				callback:function(records, operation, success){
            					var checkVal = false;
            					records.forEach(function(obj){
            						if(originalVal != obj.data.id){
            							checkVal = true;
            						}
            						else{
            							checkVal = false;
            						}
            					});
            					
            					if(checkVal){
            						combo.reset();
            					}
            				}
            			});
            		}
            	}
            }
            
        },
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						delete rec.column.getEditor().store.getProxy().extraParams.id;
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
						rec.column.getEditor().reset();
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			} else {
				if(Ext.isDefined(record.get('approverId')) && isNullOrEmpty(record.get('approverId'))){
					rec.tdCls = 'gridInputCustomStyle';
					rec.column.getEditor().reset();
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else{
					var grid = view.up();
					var hostelList =  grid.config.hostelList;
					if(!isNullOrEmpty(hostelList) && hostelList.length>0){
						var recId = record.get('id');
						var editor = rec.column.getEditor();
						var models = grid.getStore().getRange();
						/*editor.store.getProxy().extraParams = {
							id:recId
						};*/
						delete editor.store.getProxy().extraParams.id;
						editor.store.load({
							callback:function(){
								hostelList.forEach(function(obj){
									var pgId = obj.hostel.id;
									if(pgId == recId){
										if(!isNullOrEmpty(obj.defaultApprover)){
											models[rowIndex].set("approverId", obj.defaultApprover.id);
											models[rowIndex].set("hostelId", pgId);
											editor.setValue(obj.defaultApprover.id);
										}
									}
									else{
										var approverId = models[rowIndex].data.approverId;
										if(isNullOrEmpty(approverId)){
											models[rowIndex].set("approverId", null);
											rec.tdCls = 'gridInputCustomStyle';
							                return getExaminationTranslation('CLICK_TO_ENTER');
										}
									}
								});
							}
						});
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
						rec.column.getEditor().reset();
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
			}						
		}
    },{
		header : getServiceRequestTranslation('DEFAULT_APPROVER'),
        dataIndex: 'approverIdAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('approverId',null);
        	return 'Auto';
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    }],
    listeners: {
        cellclick: function(gridView,htmlElement,columnIndex,dataRecord){
        	var column = gridView.getGridColumns()[columnIndex];
            if(column.dataIndex == "approverIdAuto" || column.dataIndex == "defaultAssigneeAuto"){
            	return false;
            }
            else if(column.dataIndex == "approverId" || column.dataIndex == "assigneeId"){
            	column.getEditor().getStore().load();
            }
        }
    }
});