/**
 * @author Pritam.Patil
 * This is used for complaint setting form
 */
Ext.define('Academia.view.servicerequest.servicerequestsettings.ComplaintFormWindow',{
	extend:'Ext.window.Window',
	alias:'widget.complaintformwindow',
	modal : true,
	//resizable:true,
	autoScroll:true,
//	 title: getServiceRequestTranslation('EDIT_COMPLAINT'),
	title: getServiceRequestTranslation('EDIT_GRIEVANCE'),
	    frame: true,	
	    items: [{
	        xtype: 'form',
	        itemId: 'complaintForm',
	        standardSubmit: false,
	        plugins: "formlabelrequired",
	        defaults: {
 	            labelAlign: 'top' 	            	
 	        },
	        items: [{
	        	xtype : 'hidden',
	        	name: 'version'
	        },{
	        	xtype : 'hidden',
	        	name: 'id'
	        },{
	        	xtype:'hidden',
	        	name:'academyLocation'
	        },{
	        	xtype:'hidden',
	        	name:'complaintType',
	        	itemId:'complaintType'
	        },{
	        	xtype:'displayfield',
//	        	fieldLabel: getServiceRequestTranslation('COMPLAINT_TYPE'),GRIEVANCE_TYPE
	        	fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
	        	name:'complaintTypeField'     	
	        },{
	        	 xtype: 'fieldcontainer',
	        	 defaults: {
	 	            labelAlign: 'top',
	 	            width : 226
	 	        },
	        	 layout:'hbox',
	        	 items:[{
	 	            xtype: 'numberfield',	
		            name: 'sla',
		            minValue:0,
		            maxLength: 3,
					enforceMaxLength : true,
					keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            allowDecimals: false,
		            fieldLabel: getServiceRequestTranslation('SLA'), // SLA days
		            allowBlank: false
		        }]
	        },{
	        	 xtype: 'fieldcontainer',
	        	 defaults: {
	 	            labelAlign: 'top',
	 	            	width : 226
	 	        },
	        	 width: '100%',
	        	 layout:'hbox',
	        	 items:[ {
			            xtype: 'livesearchcombo',
			            name: 'defaultAssignee',
			            fieldLabel: getServiceRequestTranslation('DEFAULT_ASSIGNEE'), //default assignee 
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			            itemId : 'defaultAssignee'       
			        },{
		        	 xtype: 'livesearchcombo',
		             name: 'defaultApprover',
		             fieldLabel: getServiceRequestTranslation('DEFAULT_APPROVER'),
		 			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		             itemId : 'defaultApprover'//default apprrover
		        }]
	        },{
	        	 xtype: 'fieldcontainer',
	        	 defaults: {
	 	            labelAlign: 'top'	 	            	
	 	        },	        	
	        	 layout:'hbox',
	        	 items:[{
			    		xtype:'multiselectcombofield',
			    		name:'requestStatusIds',
			    		fieldLabel: getServiceRequestTranslation('FOLLOWUP_STATUS'),
			    		labelAlign:'top',
			    		store:'servicerequest.servicerequestsettings.RequestStatusStore',
			    		cls:'multiBrandCampusCls',
			    		displayField:'value',
			    		valueField:'id',
			    		width:'482px',
			    		editable:false,
			            allowBlank: false,
			    		height:'40px',
			    		//queryMode:'local',
			    		itemId:'serviceRequestSettingStatus'		
			    	}]
	        },{
	            xtype: 'fieldcontainer',
	            width: '100%',
	            style :{
	            	marginLeft: '-2px',
	            	marginTop: '7px'
	            },
	            items: [{
	                xtype: 'button',
	                itemId: 'btnSaveComplaintDetails',
	                text: getCommonTranslation('SUBMIT'), //Submit
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE,
	                formBind: true
	            },{
	                xtype: 'button',
	                text: getServiceRequestTranslation('CANCEL'),
	                ui: 'CustomBtnCancel',
	                itemId: 'cancelButtonId',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
	        }]
	    }]
});