/**
 * @author pritam.patil
 * Course Enrolled  Details Grid 
 */
Ext.define('Academia.view.servicerequest.withdrawfromcourseprogramservice.CourseEnrolledGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.courseenrolledgrid',
    border: true,
    collapsible : true,
    viewConfig: {
        stripeRows: true
    },
    selModel:Ext.create('Ext.selection.CheckboxModel',{
    	singleSelect: true,
    	showHeaderCheckbox : false,
    	itemId : 'selModelId'
    }),
    columns: [{
        header: getServiceRequestTranslation('COURSE'),
        dataIndex: 'course',
        sortable: true,
        flex: .2
    },{
        header: getServiceRequestTranslation('COURSE_GROUP'),
        dataIndex: 'courseGroup',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('MAX_CREDIT'),
        dataIndex: 'maxCredit',
        sortable: true,
        flex: .2
    },  {
        header: getServiceRequestTranslation('MIN_CREDIT'),
        dataIndex: 'minCredit',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('AUDIT_COURSE'),
        dataIndex: 'auditCourse',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('SPECIALIZATION'),
        dataIndex: 'specialization',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('OPTIONAL_COURSE'),
        dataIndex: 'optionalCourse',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getServiceRequestTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.servicerequest.withdrawfromcourseprogramservice.CourseEnrolledDetails');
    }

});