/**
 * @author pritam.patil
 * subscribe or withdraw from service Request Details Panel 
 */
Ext.define('Academia.view.servicerequest.withdrawfromcourseprogramservice.WithdrawFormServiceDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.withdrawformservicedetailspanel',
    frame: false,
    border: false,
    plugins : "formlabelrequired",
    items: [{
    	xtype:'hidden',
    	name:'id'
    },{
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    },{
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    },{
 		xtype : 'requesterdetailspanel',
 		itemId: 'requesterDetails',
 		margin : 0
   },{
 		xtype : 'basicdetails',
 		itemId : 'withServiceBasicDetails',
 		margin : 0
   },{
       xtype: 'fieldcontainer',
       defaults: {
           width: 226,
           labelAlign: 'top'
       },
       style :{
    	   marginLeft : '10px',
    	   marginTop : '-24px'
       },
       items: [{
       xtype: 'datefield',
       fieldLabel: getServiceRequestTranslation('VALID_FROM_DATE'),
       name: 'validFromDate',
       allowBlank:false,
     //--submitFormat: CONSTANTS.DATE_FORMAT,
       itemId: 'RequestDate',
       listeners: {
    	   render: function(field) {
    		   return dateFormatRender(field);
    	   }
       }
       }]
       },{
        xtype: 'fieldcontainer',
        fieldLabel :  getServiceRequestTranslation('SERVICES'),
        layout: {
            type: 'hbox'
        },
        style :{
     	   marginLeft : '10px'
        },
        items: [{
    	xtype : 'radiogroup',
    	itemId:'whetherSubscribed',
    	items:[{
    		    boxLabel: getServiceRequestTranslation('SUBSCRIBE'),
    	        name: 'whetherSubscribed',
    	        inputValue: true,
    	        checked:true
	    	},{        	
	            boxLabel: getServiceRequestTranslation('WITHDRAWAL'),
	            name: 'whetherSubscribed',            
	            inputValue: false         
	        }]       
    }]
    },{
    	xtype: 'fieldcontainer',       
        layout: {
            type: 'hbox'
        },
        style :{
     	   marginLeft : '10px'
        },
        items: [{
    		xtype:'multiselectcombofield',
    		name:'subscribedServices',
    		fieldLabel: getServiceRequestTranslation('SERVICES_TO_BE_SUBSCRIBED'),
    		labelAlign:'top',
    		store:'servicerequest.withdrawservice.OptedServices',
    		displayField:'value',
    		valueField:'id',
    		editable:false,
    		queryMode:'local',
    		width:300,
    		autoloadStore: false,
    		itemId:'servicesOpted'		
    	},{
    		xtype:'multiselectcombofield',
    		name:'withdrawnServices',
    		fieldLabel: getServiceRequestTranslation('SERVICES_TO_WITHDRAW'),
    		labelAlign:'top',
    		store:'servicerequest.withdrawservice.UnOptServices',
    		displayField:'value',
    		valueField:'id',
    		editable:false,
    		queryMode:'local',
    		width:300,
    		autoloadStore: false,
    		itemId:'servicesToWithdraw',
    		hidden:true,
    		disabled:true
    	},{
    		xtype:'multiselectcombofield',
    		name:'alreadySubscribedServices',
    		fieldLabel: getServiceRequestTranslation('SERVICES_SUBSCRIBED'),
    		labelAlign:'top',
    		store:'servicerequest.withdrawservice.UnOptServices',
    		displayField:'value',
    		valueField:'id',
    		editable:false,
    		queryMode:'local',
    		width:200,
    		autoloadStore: false,
    		itemId:'alreadySubscribedServices',
    		hidden:false,
    		disabled:true,
    		readOnly:true
    	}]
    },{
        xtype: 'button',
        text: getServiceRequestTranslation('UPLOAD_DOC'),
        ui: 'CustomBtnSubmit',
        itemId: 'subSubmitBtn',
        style :{
     	   marginLeft : '10px',
     	   marginTop : '20px'
        },
        formBind:true,
        scale: CONSTANTS.BUTTONSIZE
    },{
        xtype: 'button',
        text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
        ui: 'CustomBtnSubmit',
        itemId: 'withdrawButtonId',
        scale: CONSTANTS.BUTTONSIZE,
        style :{
     	   marginLeft : '10px',
     	   marginTop : '20px'
        },
        hidden: true
    }]
});