/**
 */

Ext.define('Academia.view.setup.quickLink.QuickLinkWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.quicklinkwin',
	title: getCommonTranslation('QUICK_LINK_SETUP_FORM'),
	frame: true,
	autoScroll:true,
	//cls: 'electionCandidateInfoWincls',
	modal:true,
	layout : {
	    type  : 'hbox',
	    pack  : 'center',
	    align : 'middle'
	},
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'quickLinkWin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226,
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			itemId:'quickLinkId',
			name: 'quickLinkId'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation("PORTAL"),
				name: 'portalId',
				itemId:'portalId',
				store: 'setup.quickLink.QuickLinkWinForPortalStore',
				displayField: 'portalName',
				valueField: 'id',
				minChars:3,
				editable : false,
				typeAhead:true,
				forceSelection :true,
				queryParam:'qry',
				allowBlank:false,
			},{
			xtype:'textfield',
			name: 'linkName',
			fieldLabel: getCommonTranslation('LINK_NAME'),
			itemId:'linkName',
			maxLength:255,
			allowBlank: false
		}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top',
			},
			items:[{
				xtype:'textfield',
				name: 'linkUrl',
				fieldLabel: getCommonTranslation('LINK_URL'),
				itemId:'linkUrl',
				maxLength:255,
				allowBlank: false
			},{
				xtype : 'filefield',
				itemId : 'imageUploadField',
				name : 'imageUploadField',
				 ui: 'CustomBtnSubmit',
		            name: 'file',
		            fieldLabel: getCommonTranslation('LOGO'),
		            buttonText: getPersonModuleTranslation('UPLOAD'),
			},{

				itemId : 'lblMaxSize',
	        	html: '<span class="required" style="color:grey">'+'Size upto 50 KB.'+'</span>',
	        	style : {
	    			marginLeft : '-238px !important',
	    			marginTop : '60px !important'
	    		}
	        
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top',
			},
			style:{
				'margin-top': '-30px'
			},
			items:[{
				xtype:'numberfield',
				name: 'sequenceNo',
				fieldLabel: getCommonTranslation('SEQUENCE_NO'),
				itemId:'sequenceNo',
				minValue: 1,
				maxValue: 10,
				allowBlank: false
			},{
				xtype:'checkbox',
				name:'whetherActive',
				itemId:'whetherActive',
				style:{
					'margin-top': '25px !important',
//					'margin-left': '8px !important'
				},
				checked: false,
				uncheckedValue: false,
				cls: 'quickLinkCheckbox',
				//boxLabelAlign:'before',
				boxLabel:getCommonTranslation('STATUS')
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnQuickLink',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnQuickLink',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});