/**
 * @author Prakash Sharma
 */
Ext.define('Academia.view.signupSetup.SignupUploadDocumentList', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.signupuploaddocumentlist',
    store : 'Academia.store.signupAdditionalSetup.GuidelinesDocumentListStore',
//    cls:'centerAlignTitle',
    cls : 'centerAlignTitleSignUpReport',
    title: getHostelTranslation('UPLOAD_GUIDELINE_DOCUMENT'),
    border: true,
    autoScroll: true,
    columnLines : true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'Academia.store.signupAdditionalSetup.GuidelinesDocumentListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
        xtype: 'button',
        itemId: 'deleteGuidelineDocumentItemId',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },
    {
        xtype: 'button',
        itemId: 'addGuidelineDocumentItemId',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }],
    
    columns: [{
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentName',
        align: 'left',
        sortable: false,
        flex: 1,
    	renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
    }]
});