/**
 * @Author Deepika P
 */
Ext.define('Academia.view.sponsorship.QuotationDetailStructure',{
		extend : 'Ext.form.FormPanel',
		alias : 'widget.quotationdetailstructure',
		autoScroll: true,
		bodyPadding:'10 10 10 20',
		frame:true,
		title:getCommonTranslation('QUOTATION_DETAILS'),
		style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	    },
	    method: 'POST',
	     defaults: {
	  	  labelAlign: 'top',
	  	  width: 226
	  },
	 	plugins : "formlabelrequired",
	 	items : [{
	 		xtype : 'fieldcontainer',
	 		width : '100%',
	 		layout : {
	 			type : 'hbox'
	 		},
	 		defaults : {
	 			width : 226,
	 			labelAlign : 'top'
	 		},
	 		items : [{
				xtype: 'hidden',
				name:'id'
			},{
	 			xtype: 'textfield',
	 			name: 'quotationCode',
	 			itemId: 'quotationCodeId',
	 			fieldLabel: getCommonTranslation('QUOTATION_CODE'),
	 			allowBlank:false,


	 		},{
	 			xtype: 'textfield',
	 			name: 'quotationName',
	 			itemId: 'quotationNameId',
	 			fieldLabel: getCommonTranslation('QUOTATION_NAME'),
	 			allowBlank:false,
	 		},{
	 			xtype: 'datefield',
	 			name: 'quotationDate',
	 			itemId: 'quotationDateId',
	 			fieldLabel: getCommonTranslation('QUOTATION_DATE'),
	 			allowBlank:false,
	 			vtype: 'daterange',
	 			value:new Date()

	 		}]
	 	},
	 	{
	 		xtype : 'fieldcontainer',
	 		width : '100%',
	 		layout : {
	 			type : 'hbox'
	 		},
	 		defaults : {
	 			width : 226,
	 			labelAlign : 'top'
	 		},
	 		items : [{
	 			xtype: 'customcombobox',
	 			name:'createdBy',
	 			itemId:'createdById',
	 			store: 'common.AllUserBySmartSearch',
	 			//store:'common.ProgramStore',
	 			fieldLabel:getCommonTranslation('CREATED_BY'),
	 			displayField:'value',
	 			valueField:'id',
	 			queryParam:'codeOrName',
	 			minChars:3,
	 			//width:460,
	 			typeAhead:false,
	 			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	 			enableKeyEvents  : 'true',
	 			hideTrigger:false,
	 			forceSelection:true,
	 			allowBlank:false,
	 			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 						picker.maxWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
	 		},{
	 			xtype: 'customcombobox',
	 			name: 'academyLocation',
	 			itemId: 'brandCampusId',
	 			store:Ext.create('Academia.store.user.UserAcademyLocationStore'),
	 			fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
	 			editable: false,
	 			allowBlank:false,
	 			displayField: 'value',
	 			valueField: 'id',
	 			listConfig: {
	 				listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 						picker.maxWidth = picker.up('combobox').getSize().width;
	 					}
	 				}
	 			}
	 		},{
	 			xtype: 'customcombobox',
	 			name: 'approvalStatus',
	 			itemId: 'approvalStatusId',
	 			allowBlank:false,
	 			store:Ext.create('Academia.store.feeandpayment.quatationDetails.ApprovalStatusComboStore'),
	 			fieldLabel: getCommonTranslation('APPROVAL_STATUS'),
	 			displayField: 'value',
	 			valueField: 'name'	                    
	 		}]
	 	},{
	 		xtype : 'fieldcontainer',
	 		width : '100%',
	 		layout : {
	 			type : 'hbox'
	 		},
	 		defaults : {	 				
	 			labelAlign : 'top'
	 		},
	 		items : [{
	 			xtype: 'textareafield',
	 			name:'description',
	 			itemId:'descriptionId',
	 			fieldLabel: getCommonTranslation('DESCRIPTION'),
	 			width:460

	 		}]
	 	},{
	 		xtype:'panel',
	 		style:{
	 			marginLeft:'-9px'
	 		},
	 		items:[{
	 			xtype:'quotationdetaildocumentgrid',
		 		
	 		}]
	 		
	 	},{
	 		xtype: 'fieldcontainer',   	  
	 		layout : {
	 			type : 'hbox'
	 		},
	 		width:'auto',
	 		items : [ {
	 			xtype : 'button',
	 			text : getCommonTranslation('SAVE'),
	 			itemId : 'submitBtn',
	 			ui : 'CustomBtnSubmit',
	 			scale : CONSTANTS.BUTTONSIZE,
	 			formBind : true
	 		},{
	 			xtype : 'button',
	 			text : getCommonTranslation('RESET'),
	 			itemId : 'resetBtn',
	 			ui : 'CustomBtnCancel',
	 			scale : CONSTANTS.BUTTONSIZE
	 		},{
	 			xtype: 'button',
	 			text:getCommonTranslation('UPLOAD_DOC'),
	 			itemId: 'quotationDocumentUploadId',
	 			ui: 'CustomBtnThird',
	 			scale : CONSTANTS.BUTTONSIZE
	 		}]
	 	}]
});
