/**
 * @author priyanshi sharma
 *
 */
Ext.define('Academia.view.sponsorship.invoice.SponsorInvoiceUpdateAmountReceivedWin', {
	extend: 'Academia.view.personinfo.common.PersonCommonWindow',
	alias : 'widget.sponsorinvoiceupdateamountreceivedwin',
	border : true,
	title: getCommonTranslation('UPDATE_AMOUNT_RECEIVED'),
	maxHeight : 400,
	width: 600,
	resizable: false,
	bodyPadding: 10,
	items: [{
        xtype: 'container',
        layout: 'fit',
        items: [{
    		xtype: 'grid',
    		itemId: 'UpdateAmountReceivedGridId',
    		columnLines: true,
    		store:'sponsorship.invoice.SponsorInvoiceAmountReceivedStore',
    		border:true,
    		viewConfig: {
    			stripeRows: CONSTANTS.STRIPEROWS,
    			deferEmptyText: false,
    			emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    		},
    		tbar: [{
    			xtype: 'button',
    			itemId: 'btnAdd',
    			hidden: true,
    			tooltip: getCommonTranslation('ADD'),
    			glyph: ICONGLYPH.ADDGLYPH
    		}],
    		columns: [{
    			header : getCommonTranslation('DATE'),
    			dataIndex : 'receivedDate',
    			flex:1,
    			sortable: true,
    			editor: {
    				xtype: 'datefield',
    				name: 'receivedDate',
    				itemId: 'receivedDateItemId',
    				vtype: 'daterange',
    	            listeners: {
    	                render: function(field) {
    	                    return dateFormatRender(field);
    	                }
    	            }
    			},
    			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
    	            var grid = view.up();
    	            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.preFilledReceivedDate)) {
    	                rec.tdCls = 'gridInputCustomStyle';
    	                return getExaminationTranslation('CLICK_TO_ENTER');
    	            } else {
    	                var store = grid.getStore();
    	                var models = grid.getStore().getRange();
    	                if (!isNullOrEmpty(val)) {

    	                } else if (!isNullOrEmpty(record.data.preFilledReceivedDate)) {
    	                    val = record.data.preFilledReceivedDate;
    	                }
    	                models[rowIndex].set("receivedDate", val);
    	                return dateRender(val);
    	            }
    			}
    		},{
    			header : getCommonTranslation('AMOUNT_RECEIVED'),
    			dataIndex : 'receivedAmount',
    			flex:1,
    			sortable: true,
    		    editor: {
    	            xtype: 'numberfield',
    	            name: 'receivedAmount',
    	            itemId: 'receivedAmountItemId',
    	            keyNavEnabled: false,
                    mouseWheelEnabled: false,
                    minValue: 1,
                    enforceMaxLength: true,
                    maxLength: 14,       
                    allowExponential: false,
                    allowDecimals: true,
                    hideTrigger: true
    	        },
    	        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    	        	if(!isNullOrEmpty(value) && value !== '') {
    					try{
    						return value;
    					}
    					catch(e){
    						return null;
    					}
    				}
    	        	else {
    					if(Ext.isDefined(record.get('amountReceived')) && isNullOrEmpty(record.get('amountReceived'))){
    						rec.tdCls = 'gridInputCustomStyle';
    		                return getExaminationTranslation('CLICK_TO_ENTER');
    					}
    	        	}
    	        }
    		},{
    	        header: getServiceRequestTranslation('EMM_ADD'),
    	        dataIndex: 'addButton',
    	        flex: 0.5,
    	        cls: 'CustomBodyBtnSettings',
    	        tooltip : getCommonTranslation('ADD'),
    	        glyph: ICONGLYPH.ADDGLYPH,
    	        sortable: true,
    	        renderer: function(value, meta, record) {
    	        	if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)){
    	        		if(record.store.data.length-1 == meta.recordIndex){
    	        			return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight:20px !important'></div>";
    	        		}
    	        	}else{
    	        		return '';
    	        	}
    	        }
    	    }, {
    	        header: getServiceRequestTranslation('EMM_DELETE'),
    	        dataIndex: 'deleteButton',
    	        flex: 0.6,
    	        cls: 'CustomBodyBtnSettings',
    	        sortable: true,
    	        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
    	            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
    	                return "<div class='deleteButtonClsForGridActionCls'></div>";
    	            }
    	            return '';
    	        }
    	    }],
    	    plugins: {
    	    	ptype: 'cellediting',
    			clicksToEdit: 1,

    	    }
    	}]
    },{
		xtype: 'fieldcontainer',
		style:{
			marginLeft:'10px !important'
		},
		items: [{
			xtype: 'button',
			itemId: 'btnSaveUpdateAmountReceive',
			text: getCommonTranslation('SAVE'), 
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});